/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.split;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.api.BlockSource;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.PageManagerForFileChannel;
import org.aksw.commons.io.block.impl.PageNavigator;
import org.aksw.commons.util.ref.Ref;

public class InputSplits {
    public static List<Object> createInputSplits(BlockSource blockSource) throws Exception {
        long size = blockSource.size();
        int numBatches = 4;
        List<Long> rawSplits = InputSplits.createSplits(size, numBatches);
        ArrayList<Long> splits = new ArrayList<Long>();
        long priorOffset = -1L;
        for (int i = 0; i < rawSplits.size(); ++i) {
            try (Ref blockRef = blockSource.contentAtOrAfter((long)i, true);){
                if (blockRef == null) break;
                long offset = ((Block)blockRef.get()).getOffset();
                if (offset == priorOffset) continue;
                splits.add(i, offset);
                priorOffset = offset;
                continue;
            }
        }
        return null;
    }

    public static List<Long> createSplits(long size, int numBatches) {
        ArrayList<Long> result = new ArrayList<Long>();
        long chunkSize = size / (long)numBatches;
        int remainder = (int)size % numBatches;
        HashMap navs = new HashMap();
        long start = 0L;
        for (int i = 0; i < numBatches; ++i) {
            long end;
            long extra = i < remainder ? 1L : 0L;
            start = end = start + chunkSize + extra;
        }
        return result;
    }

    public static List<Object> createInputSplits(FileChannel fileChannel) throws IOException {
        PageManagerForFileChannel pageManager = PageManagerForFileChannel.create((FileChannel)fileChannel);
        long size = pageManager.size();
        int numChunks = 4;
        boolean fwd = true;
        int numRuns = 10;
        long chunkSize = size / (long)numChunks;
        int remainder = (int)size % numChunks;
        HashMap<Integer, PageNavigator> navs = new HashMap<Integer, PageNavigator>();
        long start = 0L;
        for (int i = 0; i < numChunks; ++i) {
            long extra = i < remainder ? 1L : 0L;
            long end = start + chunkSize + extra;
            navs.put(i, new PageNavigator((PageManager)pageManager, start, end));
            start = end;
        }
        return null;
    }
}

