/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.filter.sys;

import com.google.common.base.StandardSystemProperty;
import com.google.common.io.ByteStreams;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.aksw.commons.io.endpoint.FileCreation;
import org.aksw.commons.io.process.util.SimpleProcessExecutor;
import org.aksw.jena_sparql_api.io.endpoint.ConcurrentFileEndpoint;
import org.aksw.jena_sparql_api.io.endpoint.Destination;
import org.aksw.jena_sparql_api.io.endpoint.DestinationFilter;
import org.aksw.jena_sparql_api.io.endpoint.DestinationFromFile;
import org.aksw.jena_sparql_api.io.endpoint.DestinationFromFileCreation;
import org.aksw.jena_sparql_api.io.endpoint.FileWritingProcess;
import org.aksw.jena_sparql_api.io.endpoint.FilterConfig;
import org.aksw.jena_sparql_api.io.endpoint.FilterEngine;
import org.aksw.jena_sparql_api.io.endpoint.HotFile;
import org.aksw.jena_sparql_api.io.endpoint.HotFileFromJava;
import org.aksw.jena_sparql_api.io.endpoint.InputStreamSupplier;
import org.aksw.jena_sparql_api.io.endpoint.InputStreamSupplierBasic;
import org.aksw.jena_sparql_api.io.filter.sys.FileCreationWrapper;
import org.aksw.jena_sparql_api.io.filter.sys.FilterMetadata;
import org.aksw.jena_sparql_api.io.filter.sys.HotFileFromProcess;
import org.aksw.jena_sparql_api.io.filter.sys.SysCallFn;

public class FilterExecutionFromSysFunction
implements FilterConfig {
    public static final Path PROBE_PATH = Paths.get("/tmp/probe", new String[0]);
    protected SysCallFn cmdFactory;
    protected FilterMetadata filterMetadata;
    protected Destination source;

    protected FilterExecutionFromSysFunction(SysCallFn cmdFactory, Destination source) {
        this.cmdFactory = cmdFactory;
        this.source = source;
    }

    @Override
    public boolean requiresFileOutput() {
        boolean expectedTrue;
        Destination effectiveInput = this.getEffectiveSource();
        Path knownInPath = this.extractKnownPathFromDestination(effectiveInput);
        boolean result = knownInPath == null ? this.cmdFactory.buildCmdForStreamToStream() == null : this.cmdFactory.buildCmdForFileToStream(knownInPath) == null;
        Path dummyOutPath = Paths.get(StandardSystemProperty.JAVA_IO_TMPDIR.value(), new String[0]).resolve("sanity.check");
        boolean bl = knownInPath == null ? this.cmdFactory.buildCmdForStreamToFile(dummyOutPath) != null : (expectedTrue = this.cmdFactory.buildCmdForFileToFile(knownInPath, dummyOutPath) != null);
        if (!expectedTrue) {
            throw new RuntimeException("Assertion failed: Could neither obtain file nor stream output for given input");
        }
        return result;
    }

    public Path extractKnownPathFromDestination(Destination destination) {
        Path result = destination instanceof DestinationFromFile ? ((DestinationFromFile)destination).getPath() : (destination instanceof DestinationFromFileCreation ? ((DestinationFromFileCreation)destination).getFileBeingCreated() : null);
        return result;
    }

    protected Path allocateInputFile() {
        Path result;
        try {
            result = Files.createTempFile("highperfstream-input-", ".dat", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected Path allocateOutputFile() {
        Path result;
        try {
            result = Files.createTempFile("highperfstream-output-", ".dat", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Destination getEffectiveSource() {
        Destination result;
        if (this.source instanceof DestinationFilter) {
            DestinationFilter d = (DestinationFilter)this.source;
            FilterConfig priorFilter = d.getFilter();
            boolean requiresFileOutput = priorFilter.requiresFileOutput();
            if (requiresFileOutput) {
                Path tmpOutFile = this.allocateOutputFile();
                result = priorFilter.outputToFile(tmpOutFile);
            } else {
                result = priorFilter.outputToStream();
            }
        } else {
            result = this.source;
        }
        return result;
    }

    public Single<HotFile> execToHotFile(Path tgtPath) {
        Single<HotFile> result = null;
        Destination effectiveSource = this.getEffectiveSource();
        ProcessBuilder processBuilder = null;
        String[] cmd = this.cmdFactory.buildCmdForStreamToFile(tgtPath);
        if (cmd != null) {
            processBuilder = new ProcessBuilder(cmd);
        } else {
            cmd = this.cmdFactory.buildCmdForStreamToStream();
            if (cmd != null) {
                processBuilder = new ProcessBuilder(cmd);
                processBuilder.redirectOutput(tgtPath.toFile());
            }
        }
        if (processBuilder != null) {
            result = this.prepareHotFile(tgtPath, effectiveSource, processBuilder);
        }
        if (result == null && (result = this.awaitOrAllocateInputFileAndFilterToFile(effectiveSource, tgtPath)) == null) {
            Path tmpInFile = this.allocateInputFile();
            String[] probeCmd = this.cmdFactory.buildCmdForFileToFile(tmpInFile, tgtPath);
            if (probeCmd == null && (probeCmd = this.cmdFactory.buildCmdForFileToStream(tmpInFile)) == null) {
                throw new RuntimeException("probing failed");
            }
            if (probeCmd != null) {
                processBuilder = new ProcessBuilder(probeCmd);
                processBuilder.redirectOutput(tgtPath.toFile());
                result = this.prepareHotFile(tgtPath, effectiveSource, processBuilder);
            }
        }
        return result;
    }

    private Single<HotFile> prepareHotFile(Path tgtPath, Destination effectiveSource, ProcessBuilder processBuilder) {
        Single result = effectiveSource.prepareStream().map(inSupp -> {
            Map.Entry e = SimpleProcessExecutor.wrap((ProcessBuilder)processBuilder).executeCore();
            Single processSingle = (Single)e.getKey();
            Process process = (Process)e.getValue();
            new Thread(() -> {
                try (InputStream in = (InputStream)inSupp.execStream().blockingGet();
                     OutputStream out = process.getOutputStream();){
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }).start();
            HotFileFromProcess r = HotFileFromProcess.createStarted(tgtPath, (Single<Integer>)processSingle);
            return r;
        });
        return result;
    }

    private Single<InputStreamSupplier> prepareStreamToStream(Destination effectiveSource, ProcessBuilder processBuilder) {
        Single result = effectiveSource.prepareStream().map(inSupp -> () -> {
            Process process;
            try {
                process = SimpleProcessExecutor.wrap((ProcessBuilder)processBuilder).execute();
            }
            catch (InterruptedException e1) {
                throw new RuntimeException(e1);
            }
            new Thread(() -> {
                try (InputStream in = (InputStream)inSupp.execStream().blockingGet();
                     OutputStream out = process.getOutputStream();){
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }).start();
            return Single.just((Object)process.getInputStream());
        });
        return result;
    }

    public Single<? extends FileCreation> tryGetFileCreation(Destination destination) {
        Single result;
        if (destination instanceof DestinationFromFileCreation) {
            result = ((DestinationFromFileCreation)destination).getFileCreation();
        } else if (destination instanceof DestinationFromFile) {
            DestinationFromFile d = (DestinationFromFile)destination;
            Path inPath = d.getPath();
            result = Single.just((Object)new FileCreationWrapper(inPath));
        } else {
            result = null;
        }
        return result;
    }

    public Single<HotFile> awaitOrAllocateInputFileAndFilterToFile(Destination effectiveSource, Path tgtPath) {
        Single<? extends FileCreation> fileCreation = this.tryGetFileCreation(effectiveSource);
        if (fileCreation == null) {
            fileCreation = this.forceInputFileCreation(effectiveSource);
        }
        if (fileCreation == null) {
            throw new RuntimeException("Should not happen");
        }
        Single<HotFile> result = this.awaitOrAllocateInputFileAndFilterToFileCore(fileCreation, tgtPath);
        return result;
    }

    public static Single<? extends FileCreation> forceDestinationToFile(Single<InputStreamSupplier> xxx, Path tmpFile) {
        ConcurrentFileEndpoint endpoint;
        try {
            endpoint = ConcurrentFileEndpoint.create(tmpFile, StandardOpenOption.CREATE);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return xxx.map(inSupp -> {
            new Thread(() -> {
                try (InputStream in = (InputStream)inSupp.execStream().blockingGet();){
                    ByteStreams.copy((InputStream)in, (OutputStream)Channels.newOutputStream(endpoint));
                }
                catch (Exception e) {
                    endpoint.abandon();
                }
                finally {
                    try {
                        endpoint.close();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }).start();
            return new HotFileFromJava(endpoint, null);
        });
    }

    public Single<? extends FileCreation> forceInputFileCreation(Destination effectiveSource) {
        Single<? extends FileCreation> result = this.tryGetFileCreation(effectiveSource);
        if (result == null) {
            if (effectiveSource instanceof DestinationFilter) {
                Path tmpInFile;
                FilterConfig filter = ((DestinationFilter)effectiveSource).getFilter();
                DestinationFromFileCreation tmpDest = filter.outputToFile(tmpInFile = this.allocateInputFile());
                result = this.tryGetFileCreation(tmpDest);
                if (result == null) {
                    throw new RuntimeException("Should not happen");
                }
            } else {
                Path tmpInFile = this.allocateInputFile();
                result = FilterExecutionFromSysFunction.forceDestinationToFile(effectiveSource.prepareStream(), tmpInFile);
            }
        }
        if (result == null) {
            throw new RuntimeException("Could not force input to file");
        }
        return result;
    }

    public Single<HotFile> awaitOrAllocateInputFileAndFilterToFileCore(Single<? extends FileCreation> fileCreation, Path tgtPath) {
        return fileCreation.flatMap(fc -> Single.fromFuture((Future)fc.future()).map(actualInPath -> {
            ProcessBuilder processBuilder;
            String[] cmd = this.cmdFactory.buildCmdForFileToFile((Path)actualInPath, tgtPath);
            if (cmd != null) {
                processBuilder = new ProcessBuilder(cmd);
            } else {
                cmd = this.cmdFactory.buildCmdForFileToStream((Path)actualInPath);
                if (cmd != null) {
                    processBuilder = new ProcessBuilder(cmd);
                    processBuilder.redirectOutput(tgtPath.toFile());
                } else {
                    throw new RuntimeException("cmdFactory could not cope with provided arguments");
                }
            }
            Single processSingle = SimpleProcessExecutor.wrap((ProcessBuilder)processBuilder).executeFuture();
            HotFileFromProcess r = HotFileFromProcess.createStarted(tgtPath, (Single<Integer>)processSingle);
            return r;
        }));
    }

    public Single<InputStreamSupplier> awaitOrAllocateInputFileAndFilterToStream(Destination effectiveSource) {
        Single result;
        String[] probeCmd;
        Single fileCreation = this.tryGetFileCreation(effectiveSource);
        if (fileCreation == null) {
            Path tmpInFile = this.allocateInputFile();
            fileCreation = Single.just((Object)new FileCreationWrapper(tmpInFile));
        }
        if ((probeCmd = this.cmdFactory.buildCmdForFileToStream(PROBE_PATH)) != null) {
            result = fileCreation.flatMap(fc -> Single.fromFuture((Future)fc.future()).map(actualInPath -> {
                String[] cmd = this.cmdFactory.buildCmdForFileToStream((Path)actualInPath);
                return () -> {
                    Map.Entry processSingle;
                    ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                    try {
                        processSingle = SimpleProcessExecutor.wrap((ProcessBuilder)processBuilder).executeCore();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException();
                    }
                    Process process = (Process)processSingle.getValue();
                    InputStream r = process.getInputStream();
                    return Single.just((Object)r);
                };
            }));
        } else {
            probeCmd = this.cmdFactory.buildCmdForFileToFile(PROBE_PATH, PROBE_PATH);
            if (probeCmd != null) {
                Path outPath = this.allocateOutputFile();
                result = fileCreation.flatMap(fc -> Single.fromFuture((Future)fc.future()).flatMap(actualInPath -> {
                    String[] cmd = this.cmdFactory.buildCmdForFileToFile((Path)actualInPath, outPath);
                    if (cmd == null) {
                        throw new RuntimeException("cmdFactory could not cope with provided arguments");
                    }
                    Path outFile = this.allocateOutputFile();
                    Single r = this.execToHotFile(outFile).map(hotFile -> InputStreamSupplierBasic.wrap(hotFile::newInputStream));
                    return r;
                }));
            } else {
                result = null;
            }
        }
        return result;
    }

    @Override
    public Single<InputStreamSupplier> execStream() {
        Single result;
        Destination effectiveSource = this.getEffectiveSource();
        ProcessBuilder processBuilder = null;
        String[] cmd = this.cmdFactory.buildCmdForStreamToStream();
        if (cmd != null) {
            processBuilder = new ProcessBuilder(cmd);
            result = this.prepareStreamToStream(effectiveSource, processBuilder);
        } else {
            cmd = this.cmdFactory.buildCmdForStreamToFile(PROBE_PATH);
            if (cmd != null) {
                Path tmpOutFile = this.allocateOutputFile();
                result = this.execToHotFile(tmpOutFile).map(hotFile -> InputStreamSupplierBasic.wrap(hotFile::newInputStream));
            } else {
                result = this.awaitOrAllocateInputFileAndFilterToStream(effectiveSource);
            }
        }
        if (result == null) {
            throw new RuntimeException("Was not able to create a stream out of input");
        }
        return result;
    }

    @Override
    public FilterConfig ifNeedsFileInput(Supplier<Path> pathRequester, BiConsumer<Path, FileWritingProcess> processCallback) {
        return null;
    }

    @Override
    public FilterConfig ifNeedsFileOutput(Supplier<Path> pathRequester, BiConsumer<Path, FileWritingProcess> processCallback) {
        return null;
    }

    @Override
    public FilterConfig pipeInto(FilterEngine nextFilter) {
        FilterConfig result = nextFilter.forInput(this);
        return result;
    }

    @Override
    public DestinationFromFileCreation outputToFile(Path path) {
        return new DestinationFromFileCreation(path, this.execToHotFile(path));
    }

    @Override
    public Destination outputToStream() {
        return null;
    }

    public String toString() {
        return "FilterExecutionFromSysFunction [cmdFactory=" + String.valueOf(this.cmdFactory) + ", filterMetadata=" + String.valueOf(this.filterMetadata) + ", source=" + String.valueOf(this.source) + "]";
    }
}

