/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rowset.core;

import com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriter;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterBuilder;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.Context;

public abstract class RowSetStreamWriterBuilderBase
implements RowSetStreamWriterBuilder {
    protected List<Var> vars;
    protected OutputStream outputStream;
    protected Writer writer;
    protected Context context;
    protected NodeFormatter nodeFormatter;

    protected AWriter getAWriter() {
        AWriter result = this.outputStream != null ? IO.wrapUTF8((OutputStream)this.outputStream) : (this.writer != null ? IO.wrap((Writer)this.writer) : null);
        return result;
    }

    @Override
    public RowSetStreamWriterBuilder setOutput(OutputStream output) {
        this.outputStream = output;
        this.writer = null;
        return this;
    }

    @Override
    public RowSetStreamWriterBuilder setOutput(Writer output) {
        this.writer = output;
        this.outputStream = null;
        return this;
    }

    @Override
    public RowSetStreamWriterBuilder setContext(Context context) {
        this.context = context;
        return this;
    }

    @Override
    public RowSetStreamWriterBuilder setVars(List<Var> vars) {
        this.vars = vars;
        return this;
    }

    @Override
    public RowSetStreamWriterBuilder setNodeFormatter(NodeFormatter nodeFormatter) {
        this.nodeFormatter = nodeFormatter;
        return this;
    }

    @Override
    public RowSetStreamWriter build() {
        this.verify();
        RowSetStreamWriter result = this.buildActual();
        return result;
    }

    protected void verify() {
        Preconditions.checkArgument((this.outputStream != null || this.writer != null ? 1 : 0) != 0, (Object)"No output was set");
    }

    protected abstract RowSetStreamWriter buildActual();
}

