/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.binseach;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.aksw.commons.io.binseach.BinSearchScanState;
import org.aksw.commons.io.binseach.BinarySearchOnSortedFile;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.api.BlockSource;
import org.aksw.commons.io.block.api.PageManager;
import org.aksw.commons.io.block.impl.BlockEnumerator;
import org.aksw.commons.io.block.impl.PageManagerForByteBuffer;
import org.aksw.commons.io.block.impl.PageManagerForFileChannel;
import org.aksw.commons.io.block.impl.PageNavigator;
import org.aksw.commons.io.deprecated.BoyerMooreMatcherFactory;
import org.aksw.commons.io.deprecated.SeekableMatcher;
import org.aksw.commons.io.hadoop.binseach.bz2.BlockSourceBzip2;
import org.aksw.commons.io.hadoop.binseach.bz2.BlockSources;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.io.seekable.api.SeekableSource;
import org.aksw.commons.io.seekable.impl.SeekableFromBlock;
import org.aksw.commons.io.seekable.impl.SeekableSourceFromPageManager;
import org.aksw.commons.util.ref.Ref;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.Rename;

public class MainPlaygroundScanFile {
    public static Map.Entry<Long, Boolean> wcFwd(PageNavigator pageNavigator) throws IOException {
        byte delim = 10;
        boolean endsOnDelim = false;
        long count = 0L;
        pageNavigator.posToStart();
        while (true) {
            pageNavigator.posToNext(delim);
            boolean posChanged = pageNavigator.nextPos(1);
            if (!posChanged) {
                boolean bl = endsOnDelim = !pageNavigator.isPosAfterEnd();
                if (!endsOnDelim) break;
                ++count;
                break;
            }
            ++count;
        }
        return Maps.immutableEntry((Object)count, (Object)endsOnDelim);
    }

    public static Map.Entry<Long, Boolean> wcBwd(PageNavigator pageNavigator) throws IOException {
        byte delim = 10;
        long count = 0L;
        pageNavigator.posToEnd();
        pageNavigator.prevPos(1);
        boolean endsOnDelim = false;
        while (true) {
            pageNavigator.posToPrev(delim);
            boolean posChanged = pageNavigator.prevPos(1);
            if (!posChanged) {
                boolean bl = endsOnDelim = !pageNavigator.isPosBeforeStart();
                if (!endsOnDelim) break;
                ++count;
                break;
            }
            ++count;
        }
        return Maps.immutableEntry((Object)count, (Object)endsOnDelim);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Rename.renameVars((Op)Algebra.compile((Query)QueryFactory.create((String)"SELECT * {\n    { SELECT ?x { ?x ?p ?o } }\n    LATERAL {\n        { ?x ?ap ?ao }\n        LATERAL { BIND(?x AS ?s) BIND(?ap AS ?p) BIND(?ao AS ?o) }\n    }\n}\n")), List.of()));
        System.out.println(Rename.renameVars((Op)Algebra.compile((Query)QueryFactory.create((String)"PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nPREFIX schema: <http://schema.org/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX wdt: <http://www.wikidata.org/prop/direct/>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX eg: <http://www.example.org/>\nPREFIX wd: <http://www.wikidata.org/entity/>\n\nSELECT ?s ?p ?o {\n   SERVICE <x-binsearch:vfs:file:///media/raven/T9/raven/datasets/wikidata/2024-08-30.wikidata.all.itypes.sorted.nt.bz2> {\n    {\n      SELECT ?x {\n        wd:Q11424 eg:hasInstances ?i .\n        ?i eg:hasInstance ?x .\n      } LIMIT 10\n    }\n    LATERAL {\n      {\n        {\n          ?x ?ap ?ao # Literals\n          # FILTER(?ap NOT IN(schema:name, skos:prefLabel))\n          # wdt:P1874 netflix\n    FILTER(?ap IN(rdfs:label, wdt:P577, schema:description, wdt:P1874))\n          FILTER(isLiteral(?ao) && (DATATYPE(?ao) != rdf:langString || lang(?ao) = 'en'))\n        } LATERAL{ BIND(?x AS ?s) BIND(?ap AS ?p) BIND(?ao AS ?o) }\n      }\n      UNION {\n        {\n          ?x ?bp ?bo\n        # P2047 -> duration\n        # P10 -> relevant video\n        # P136 -> genre\n        # P18 -> depiction\n          FILTER(?bp IN (wdt:P10, wdt:P2047, wdt:P136, wdt:P18))\n        }\n        LATERAL { {\n            BIND(?x AS ?s)\n            BIND(?bp AS ?p)\n            BIND(?bo AS ?o)\n          } UNION {\n            {\n              ?bo ?cp ?co\n              FILTER(?cp = rdfs:label)\n              FILTER(lang(?co) = 'en')\n            } LATERAL { BIND(?bo AS ?s) BIND(?cp AS ?p) BIND(?co AS ?o) }\n          }\n      }\n      }\n      }\n      }\n  }\nLIMIT 10000\n")), List.of()));
    }

    public static void mainBz2DecodeNice(String[] args) throws Exception {
        Path path = Paths.get("/home/raven/Downloads/2015-11-02-Amenity.node.sorted.fixed.nt.bz2", new String[0]);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            BinarySearcher bs = BlockSources.createBinarySearcherBz2((FileChannel)fileChannel, (int)0x1000000, (boolean)false);
            System.out.println("Matches:");
            String str = "<http://linkedgeodata.org/geometry/node1003603551>";
            try (InputStream in = bs.search(str);){
                MainPlaygroundScanFile.printLines(in, 5);
            }
        }
    }

    public static void printLines(InputStream in, int count) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        int i = 0;
        while ((line = br.readLine()) != null) {
            System.out.println(line);
            if (++i <= count) continue;
        }
        System.out.println(i + " lines");
    }

    public static void mainBz2Decode(String[] args) throws Exception {
        Path path = Paths.get("/home/raven/Downloads/2015-11-02-Amenity.node.sorted.fixed.nt.bz2", new String[0]);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            String line;
            PageManagerForFileChannel pageManager = PageManagerForFileChannel.create((FileChannel)fileChannel);
            long maxBlockOffset = pageManager.size();
            SeekableSourceFromPageManager pagedSource = new SeekableSourceFromPageManager((PageManager)pageManager);
            BlockSource blockSource = BlockSourceBzip2.create((SeekableSource)pagedSource);
            byte[] prefix = "<http://linkedgeodata.org/geometry/node1583470199>".getBytes();
            Ref blockRef = BlockSources.binarySearch((BlockSource)blockSource, (long)0L, (long)maxBlockOffset, (byte)10, (byte[])prefix);
            if (blockRef == null) {
                System.out.println("No match found");
                return;
            }
            Block block = (Block)blockRef.get();
            System.out.println("Block offset: " + block.getOffset());
            int extraBytes = 0;
            BlockEnumerator it = BlockEnumerator.fwd((boolean)true, (Ref)blockRef, (boolean)true);
            while (it.hasNext()) {
                it.advance();
                SeekableFromBlock seekable = new SeekableFromBlock(it.blockRef, 0, 0L);
                boolean found = seekable.posToNext((byte)10);
                if (!found) continue;
                extraBytes = Ints.checkedCast((long)seekable.getPos());
                it.closeCurrent();
                break;
            }
            System.out.println("Extra bytes: " + extraBytes);
            long blockSize = block.length();
            System.out.println("Block size: " + blockSize);
            long maxPos = blockSize + (long)extraBytes;
            SeekableFromBlock decodedView = new SeekableFromBlock(it.blockRef, 0, 0L, Long.MIN_VALUE, maxPos);
            long findPos = decodedView.binarySearch(0L, maxPos, (byte)10, prefix);
            if (findPos == Long.MIN_VALUE) {
                System.out.println("No pos found in block");
                return;
            }
            System.out.println(findPos);
            long start = BinarySearchOnSortedFile.getPosOfFirstMatch((Seekable)decodedView, (byte)10, (byte[])prefix);
            decodedView.setPos(start + 1L);
            BinSearchScanState state = new BinSearchScanState();
            state.firstDelimPos = start;
            state.matchDelimPos = findPos;
            state.prefixBytes = prefix;
            state.size = Long.MAX_VALUE;
            InputStream in = BinarySearchOnSortedFile.newInputStream((Seekable)decodedView, (BinSearchScanState)state);
            System.out.println("Start: " + start);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int i = 0;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                if (++i <= 100) continue;
            }
            System.out.println(i + " lines");
        }
    }

    public static void mainBoyerMooreTest(String[] args) throws IOException {
        String str = "aaaabbbbccccdddd";
        Path path = Paths.get("/home/raven/Projects/Eclipse/sparql-integrate-parent/ngs/test2.nq", new String[0]);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            PageManagerForFileChannel pageManager = PageManagerForFileChannel.create((FileChannel)fileChannel);
            byte[] text = "ABAAAABAACDABA".getBytes();
            pageManager = new PageManagerForByteBuffer(ByteBuffer.wrap(text));
            PageNavigator nav = new PageNavigator((PageManager)pageManager);
            nav.posToStart();
            String pattern = "ABA";
            byte[] patternBytes = pattern.getBytes();
            SeekableMatcher matcher = BoyerMooreMatcherFactory.createFwd((byte[])patternBytes).newMatcher();
            for (int xx = 0; xx < 10; ++xx) {
                Stopwatch sw = Stopwatch.createStarted();
                matcher.resetState();
                nav.posToStart();
                int matchCnt = 0;
                while (matcher.find((Seekable)nav)) {
                    ++matchCnt;
                }
                System.out.println("Nav at pos: " + nav.getPos());
                System.out.println("Got " + matchCnt + " matches in " + (double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
            }
            return;
        }
    }

    public static void mainWc(String[] args) throws IOException {
        Path path = Paths.get("/home/raven/Projects/Eclipse/sparql-integrate-parent/ngs/test2.nq", new String[0]);
        for (int i = 0; i < 0; ++i) {
            Stopwatch sw = Stopwatch.createStarted();
            System.out.println("Lines: " + Files.lines(path).count());
            System.out.println((double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
        }
        String str1 = "\n      \n  \n    \n";
        String str = " \n     \n  \n    \n";
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            int i;
            PageManagerForFileChannel pageManager = PageManagerForFileChannel.create((FileChannel)fileChannel);
            long size = pageManager.getEndPos();
            int numChunks = 4;
            boolean fwd = true;
            int numRuns = 10;
            long chunkSize = size / (long)numChunks;
            int remainder = (int)size % numChunks;
            HashMap<Integer, PageNavigator> navs = new HashMap<Integer, PageNavigator>();
            long start = 0L;
            for (i = 0; i < numChunks; ++i) {
                long extra = i < remainder ? 1L : 0L;
                long end = start + chunkSize + extra;
                navs.put(i, new PageNavigator((PageManager)pageManager, start, end));
                start = end;
            }
            for (i = 0; i < numRuns; ++i) {
                Stopwatch sw = Stopwatch.createStarted();
                List ready = navs.entrySet().stream().sorted((a, b) -> ((Integer)a.getKey() - (Integer)b.getKey()) * (fwd ? 1 : -1)).collect(Collectors.toList());
                List contribs = ready.parallelStream().map(e -> {
                    try {
                        Map.Entry<Long, Boolean> f = fwd ? MainPlaygroundScanFile.wcFwd((PageNavigator)e.getValue()) : MainPlaygroundScanFile.wcBwd((PageNavigator)e.getValue());
                        return Maps.immutableEntry((Object)((Integer)e.getKey()), f);
                    }
                    catch (IOException x) {
                        throw new RuntimeException(x);
                    }
                }).sorted((a, b) -> ((Integer)a.getKey() - (Integer)b.getKey()) * (fwd ? 1 : -1)).collect(Collectors.toList());
                long count = contribs.stream().mapToLong(e -> (Long)((Map.Entry)e.getValue()).getKey()).sum();
                boolean endsOnDelim = (Boolean)((Map.Entry)((Map.Entry)contribs.get(contribs.size() - 1)).getValue()).getValue();
                if (!endsOnDelim && fwd) {
                    ++count;
                }
                System.out.println("Contribs: " + String.valueOf(contribs) + " raw sum: " + contribs.stream().mapToLong(e -> (Long)((Map.Entry)e.getValue()).getKey()).sum());
                System.out.println("count, fwd=" + fwd + ": " + count + " " + (double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
            }
        }
    }
}

