/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rowset.csv;

import java.io.IOException;
import java.util.List;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriter;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterBuilderBase;
import org.aksw.jenax.io.rowset.core.RowSetStreamWriterFactory;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class RowSetStreamWriterTSV
implements RowSetStreamWriter {
    public static final RowSetStreamWriterFactory factory = () -> new RowSetStreamWriterBuilderTSV();
    private static final String NL = "\n";
    private static final String SEP = "\t";
    private static final String headerBytes = "?_askResult\n";
    private static final String yesString = "true";
    private static final String noString = "false";
    protected AWriter out;
    protected Context context;
    protected List<Var> vars;
    protected NodeFormatter nodeFormatter;

    protected RowSetStreamWriterTSV(AWriter out, List<Var> vars, NodeFormatter nodeFormatter, Context context) {
        this.out = out;
        this.vars = vars;
        this.context = context;
        this.nodeFormatter = nodeFormatter;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void writeAskResult(boolean booleanResult) {
        try {
            this.out.write(headerBytes);
            if (booleanResult) {
                this.out.write(yesString);
            } else {
                this.out.write(noString);
            }
            this.out.write(NL);
        }
        finally {
            this.out.flush();
        }
    }

    @Override
    public void writeHeader() {
        String sep = null;
        for (Var var : this.vars) {
            if (sep != null) {
                this.out.write(sep);
            } else {
                sep = SEP;
            }
            this.out.write("?");
            this.out.write(var.getVarName());
        }
        this.out.write(NL);
    }

    @Override
    public void beginBindings() {
    }

    @Override
    public void writeBindingSeparator() {
    }

    @Override
    public void endBindings() {
    }

    @Override
    public void writeFooter() {
    }

    @Override
    public void writeBinding(Binding binding) {
        String sep = null;
        for (Var v : this.vars) {
            if (sep != null) {
                this.out.write(sep);
            }
            sep = SEP;
            Node n = binding.get(v);
            if (n == null) continue;
            this.nodeFormatter.format(this.out, n);
        }
        this.out.write(NL);
    }

    public static class RowSetStreamWriterBuilderTSV
    extends RowSetStreamWriterBuilderBase {
        @Override
        protected RowSetStreamWriter buildActual() {
            AWriter awriter = this.getAWriter();
            NodeFormatter finalNodeFormatter = this.nodeFormatter != null ? this.nodeFormatter : new NodeFormatterTTL(null, null);
            return new RowSetStreamWriterTSV(awriter, this.vars, finalNodeFormatter, this.context);
        }
    }
}

