/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform;

import java.util.List;
import org.aksw.jenax.graphql.sparql.v2.util.ExprUtils;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.graph.NodeTransform;

public class VarExprListUtils {
    private static Expr transform(Expr expr, ExprTransform exprTransform) {
        if (expr == null || exprTransform == null) {
            return expr;
        }
        return ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
    }

    public static VarExprList transform(VarExprList varExpr, ExprTransform exprTransform) {
        List vars = varExpr.getVars();
        VarExprList varExpr2 = new VarExprList();
        boolean changed = false;
        for (Var v : vars) {
            Expr e;
            Expr newVE = exprTransform.transform(new ExprVar(v));
            Var newV = newVE == null ? v : ((ExprVar)newVE).asVar();
            changed = changed || !v.equals((Object)newV);
            Expr e2 = e = varExpr.getExpr(v);
            if (e != null) {
                e2 = VarExprListUtils.transform(e, exprTransform);
            }
            if (e2 == null) {
                varExpr2.add(newV);
            } else {
                varExpr2.add(newV, e2);
            }
            if (e == e2) continue;
            changed = true;
        }
        if (!changed) {
            return varExpr;
        }
        return varExpr2;
    }

    public static VarExprList transform(VarExprList vel, NodeTransform nodeTransform) {
        VarExprList result = new VarExprList();
        for (Var v : vel.getVars()) {
            Expr e = vel.getExpr(v);
            Var newV = (Var)nodeTransform.apply((Object)v);
            Expr newExpr = e == null ? null : ExprUtils.applyNodeTransform(e, nodeTransform);
            result.add(newV, newExpr);
        }
        return result;
    }

    public static void replace(VarExprList dst, VarExprList src) {
        if (dst != src) {
            dst.clear();
            VarExprListUtils.copy(dst, src);
        }
    }

    public static VarExprList copy(VarExprList dst, VarExprList src) {
        for (Var v : src.getVars()) {
            Expr e = src.getExpr(v);
            if (e == null) {
                dst.add(v);
                continue;
            }
            dst.add(v, e);
        }
        return dst;
    }
}

