/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.util;

import graphql.com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jenax.graphql.sparql.v2.util.ElementTransformSubst2;
import org.aksw.jenax.graphql.sparql.v2.util.TripleUtils;
import org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform.ElementTransformer;
import org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;

public class ElementUtils {
    public static Element recursivelyUnnestGroupsOfOne(Element elt) {
        ElementGroup g;
        return elt instanceof ElementGroup && (g = (ElementGroup)elt).size() == 1 ? ElementUtils.recursivelyUnnestGroupsOfOne(g.get(0)) : elt;
    }

    public static ElementTriplesBlock createElementTriple(Node s, Node p, Node o) {
        return ElementUtils.createElement(Triple.create((Node)s, (Node)p, (Node)o));
    }

    public static ElementTriplesBlock createElementTriple(Node s, Node p, Node o, boolean isForward) {
        return ElementUtils.createElement(TripleUtils.create(s, p, o, isForward));
    }

    public static ElementTriplesBlock createElement(Triple triple) {
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        ElementTriplesBlock result = new ElementTriplesBlock(bgp);
        return result;
    }

    public static ElementPathBlock createElementPath(Node s, Path p, Node o) {
        ElementPathBlock result = ElementUtils.createElementPath(new TriplePath(s, p, o));
        return result;
    }

    public static ElementPathBlock createElementPath(TriplePath ... tps) {
        ElementPathBlock result = ElementUtils.createElementPath(Arrays.asList(tps));
        return result;
    }

    public static ElementPathBlock createElementPath(Iterable<TriplePath> it) {
        ElementPathBlock result = new ElementPathBlock();
        for (TriplePath tp : it) {
            result.addTriple(tp);
        }
        return result;
    }

    public static ElementGroup createElementGroup(Element ... members) {
        ElementGroup result = new ElementGroup();
        for (Element member : members) {
            result.addElement(member);
        }
        return result;
    }

    public static Element groupIfNeeded(Iterable<? extends Element> members) {
        ElementGroup result = Iterables.size(members) == 1 ? members.iterator().next() : ElementUtils.createElementGroup(members);
        return result;
    }

    public static Element groupIfNeeded(Element ... members) {
        Element result = ElementUtils.groupIfNeeded(Arrays.asList(members));
        return result;
    }

    public static ElementGroup createElementGroup(Iterable<? extends Element> members) {
        ElementGroup result = new ElementGroup();
        for (Element element : members) {
            result.addElement(element);
        }
        return result;
    }

    public static Element unionIfNeeded(Element ... elements) {
        Element result = ElementUtils.unionIfNeeded(Arrays.asList(elements));
        return result;
    }

    public static Element unionIfNeeded(Collection<Element> elements) {
        Element result;
        if (elements.size() == 1) {
            result = elements.iterator().next();
        } else {
            ElementUnion e = new ElementUnion();
            for (Element element : elements) {
                e.addElement(element);
            }
            result = e;
        }
        return result;
    }

    public static Stream<Element> steamGroupMembersOrSelf(Element elt) {
        Stream<Object> stream;
        if (elt instanceof ElementGroup) {
            ElementGroup g = (ElementGroup)elt;
            stream = g.getElements().stream();
        } else {
            stream = Stream.of(elt);
        }
        return stream;
    }

    public static Element flatGroup(Element ... elts) {
        return ElementUtils.flatGroup(Arrays.asList(elts));
    }

    public static Element flatGroup(Collection<Element> elts) {
        ElementGroup group = new ElementGroup();
        elts.stream().flatMap(ElementUtils::steamGroupMembersOrSelf).forEach(arg_0 -> ((ElementGroup)group).addElement(arg_0));
        return group.size() == 1 ? group.get(0) : group;
    }

    public static ElementGroup copyElements(ElementGroup target, Element source) {
        if (source instanceof ElementGroup) {
            ElementGroup es = (ElementGroup)source;
            for (Element e : es.getElements()) {
                target.addElement(e);
            }
        } else {
            target.addElement(source);
        }
        return target;
    }

    public static NodeTransform createNodeTransform(Map<?, ? extends Node> nodeMap) {
        return node -> {
            Node r = (Node)nodeMap.get(node);
            if (r == null) {
                r = node;
            }
            return r;
        };
    }

    public static Element createRenamedElement(Element element, Map<?, ? extends Node> nodeMap) {
        NodeTransform nodeTransform = ElementUtils.createNodeTransform(nodeMap);
        Element result = ElementUtils.applyNodeTransform(element, nodeTransform);
        return result;
    }

    public static Element applyNodeTransform(Element element, NodeTransform nodeTransform) {
        return ElementUtils.applyNodeTransformBackport(element, nodeTransform);
    }

    public static Element applyNodeTransformBackport(Element element, NodeTransform nodeTransform) {
        ElementTransformSubst2 elementTransform = new ElementTransformSubst2(nodeTransform);
        ExprTransformNodeElement exprTransform = new ExprTransformNodeElement(nodeTransform, (ElementTransform)elementTransform);
        Element result = ElementTransformer.transform(element, (ElementTransform)elementTransform, (ExprTransform)exprTransform);
        return result;
    }

    public static Element applyNodeTransformJena(Element element, NodeTransform nodeTransform) {
        ElementTransformSubst2 elementTransform = new ElementTransformSubst2(nodeTransform);
        org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement exprTransform = new org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement(nodeTransform, (ElementTransform)elementTransform);
        Element result = org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer.transform((Element)element, (ElementTransform)elementTransform, (ExprTransform)exprTransform);
        return result;
    }

    public static List<Var> inferConnecVars(Element element) {
        List<Var> result = null;
        Element elt = ElementUtils.recursivelyUnnestGroupsOfOne(element);
        if (elt instanceof ElementSubQuery) {
            ElementSubQuery e = (ElementSubQuery)elt;
            Query q = e.getQuery();
            List projVars = q.getProjectVars();
            int n = projVars.size();
            if (n > 0 && n <= 3) {
                result = List.of((Var)projVars.get(0), (Var)projVars.get(n - 1));
            }
        } else {
            Op op = Algebra.compile((Element)element);
            Set visibleVars = OpVars.visibleVars((Op)op);
            Tuple mentions = OpVars.mentionedVarsByPosition((Op)op);
            Set ss = (Set)mentions.get(1);
            Set oo = (Set)mentions.get(3);
            Set unknowns = (Set)mentions.get(4);
            if (!(!unknowns.isEmpty() || ss.size() > 1 || oo.size() > 1 || ss.isEmpty() && oo.isEmpty())) {
                result = new ArrayList<Var>(2);
                if (ss.size() == 1) {
                    result.add((Var)ss.iterator().next());
                }
                if (oo.size() == 1) {
                    result.add((Var)oo.iterator().next());
                }
            }
            if (result == null && visibleVars.size() == 1) {
                result = List.of((Var)visibleVars.iterator().next());
            }
        }
        return result;
    }
}

