/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.ron;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Map;
import org.aksw.jenax.graphql.sparql.v2.io.GraphQlIoBridge;
import org.aksw.jenax.graphql.sparql.v2.io.RdfObjectNotationWriterViaJson;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfArray;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElement;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElementVisitor;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfLiteral;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfNull;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfObject;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.path.P_Path0;

public class RdfElementVisitorRdfToJson
implements RdfElementVisitor<JsonElement> {
    @Override
    public JsonElement visit(RdfArray elements) {
        JsonArray result = new JsonArray();
        for (RdfElement item : elements) {
            JsonElement elt = item.accept(this);
            result.add(elt);
        }
        return result;
    }

    @Override
    public JsonElement visit(RdfObject obj) {
        JsonObject result = new JsonObject();
        for (Map.Entry<P_Path0, RdfElement> e : obj.getMembers().entrySet()) {
            P_Path0 path = e.getKey();
            Node key = path.getNode();
            Node id = obj.getExternalId();
            String name = RdfObjectNotationWriterViaJson.nodeToJsonKey(key);
            JsonElement elt = e.getValue().accept(this);
            result.add(name, elt);
        }
        return result;
    }

    @Override
    public JsonElement visit(RdfLiteral element) {
        Node node = element.getInternalId();
        JsonElement result = GraphQlIoBridge.nodeToJsonElement(node);
        return result;
    }

    @Override
    public JsonElement visit(RdfNull element) {
        return JsonNull.INSTANCE;
    }
}

