/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Argument;
import graphql.language.BooleanValue;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.aksw.jenax.graphql.sparql.v2.context.BindDirective;
import org.aksw.jenax.graphql.sparql.v2.context.VocabDirective;
import org.aksw.jenax.graphql.sparql.v2.rewrite.JenaGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.rewrite.NodeVisitorPrefixesBase;
import org.aksw.jenax.graphql.sparql.v2.rewrite.XGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.util.GraphQlUtils;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.PrefixMappingAdapter;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.ExprUtils;

public class TransformExpandShorthands
extends NodeVisitorPrefixesBase {
    @Override
    public TraversalControl visitInlineFragmentActual(InlineFragment node, TraverserContext<Node> context) {
        return this.process("", (Node)node, (DirectivesContainer<?>)node, context, (BiFunction)(n, newDirectives) -> n.transform(builder -> builder.directives(newDirectives)));
    }

    @Override
    public TraversalControl visitFieldActual(Field field, TraverserContext<Node> context) {
        return this.process(field.getName(), (Node)field, (DirectivesContainer<?>)field, context, (BiFunction)(node, newDirectives) -> node.transform(builder -> builder.directives(newDirectives)));
    }

    @Override
    public TraversalControl visitFieldDefinitionActual(FieldDefinition node, TraverserContext<Node> context) {
        return this.process(node.getName(), (Node)node, (DirectivesContainer<?>)node, context, (BiFunction)(n, newDirectives) -> n.transform(builder -> builder.directives(newDirectives)));
    }

    @Override
    public TraversalControl visitInterfaceTypeDefinitionActual(InterfaceTypeDefinition node, TraverserContext<Node> context) {
        return this.process(node.getName(), (Node)node, (DirectivesContainer<?>)node, context, (BiFunction)(n, newDirectives) -> n.transform(builder -> builder.directives(newDirectives)));
    }

    @Override
    public TraversalControl visitObjectTypeDefinitionActual(ObjectTypeDefinition node, TraverserContext<Node> context) {
        return this.process(node.getName(), (Node)node, (DirectivesContainer<?>)node, context, (BiFunction)(n, newDirectives) -> n.transform(builder -> builder.directives(newDirectives)));
    }

    public <T extends Node<T>> TraversalControl process(String nodeName, T node, DirectivesContainer<?> field, TraverserContext<Node> context, BiFunction<T, List<Directive>, T> transform) {
        List binds;
        Directive via;
        String str;
        Directive index;
        Directive pattern;
        PrefixMap pm = TransformExpandShorthands.getEffectivePrefixMap(context);
        PrefixMappingAdapter pming = new PrefixMappingAdapter(pm);
        String vocabIri = TransformExpandShorthands.processVocab(field, context);
        Object fieldIri = vocabIri == null ? null : vocabIri + nodeName;
        List rdfDirectives = field.getDirectives("rdf");
        boolean hasEmitRdfKey = field.hasDirective("emitRdfKey");
        LinkedList remainingDirectives = new LinkedList(field.getDirectives());
        boolean changed = false;
        boolean hasPattern = false;
        boolean isForward = !field.hasDirective("reverse");
        ListIterator<Directive> it = remainingDirectives.listIterator();
        while (it.hasNext()) {
            Directive directive = (Directive)it.next();
            if (!"class".equals(directive.getName())) continue;
            String finalIri = JenaGraphQlUtils.parseRdfIri(nodeName, directive, "iri", "ns", pm);
            if (finalIri == null) {
                throw new RuntimeException("Could not resolve @class annotation to an IRI. Set @vocab or provide arguments to @class.");
            }
            it.remove();
            Directive replacement = TransformExpandShorthands.newDirectiveSource(finalIri);
            it.add(replacement);
            changed = true;
        }
        if (!rdfDirectives.isEmpty()) {
            Directive rdfDirective = (Directive)rdfDirectives.get(rdfDirectives.size() - 1);
            fieldIri = JenaGraphQlUtils.parseRdfIri(nodeName, rdfDirective, "iri", "ns", pm);
            boolean removeShortcuts = true;
            hasPattern = field.hasDirective("pattern");
            Set<String> handledFields = Set.of("rdf", "reverse");
            remainingDirectives = field.getDirectives().stream().filter(x -> !removeShortcuts || !handledFields.contains(x.getName())).collect(Collectors.toCollection(LinkedList::new));
            if (!hasPattern) {
                Directive p = TransformExpandShorthands.newDirectivePattern((String)fieldIri, isForward);
                remainingDirectives.addFirst(p);
                changed = true;
                hasPattern = true;
            }
            if (!hasEmitRdfKey) {
                Directive.Builder pb = Directive.newDirective().name("emitRdfKey").argument(Argument.newArgument((String)"iri", (Value)StringValue.of((String)fieldIri)).build());
                if (!isForward) {
                    pb.argument(Argument.newArgument((String)"reverse", (Value)BooleanValue.of((boolean)true)).build());
                }
                Directive p = pb.build();
                remainingDirectives.addFirst(p);
                changed = true;
            }
        }
        if ((pattern = GraphQlUtils.expectAtMostOneDirective(field, "pattern")) != null) {
            remainingDirectives.removeIf(x -> "pattern".equals(x.getName()));
            String str2 = GraphQlUtils.getArgAsString(pattern, "of");
            Element elt = XGraphQlUtils.parseElement(str2, pm, null);
            Directive newPattern = pattern.transform(builder -> builder.arguments(pattern.getArguments().stream().map(arg -> "of".equals(arg.getName()) ? GraphQlUtils.newArgString("of", elt.toString()) : arg).toList()));
            remainingDirectives.addFirst(newPattern);
            changed = true;
        }
        if ((index = GraphQlUtils.expectAtMostOneDirective(field, "index")) != null && (str = GraphQlUtils.getArgAsString(index, "by")) != null) {
            remainingDirectives.removeIf(x -> "index".equals(x.getName()));
            Expr expr = ExprUtils.parse((String)str, (PrefixMapping)pming);
            Directive newIndex = index.transform(builder -> builder.arguments(index.getArguments().stream().map(arg -> "by".equals(arg.getName()) ? Argument.newArgument((String)"by", (Value)StringValue.of((String)ExprUtils.fmtSPARQL((Expr)expr))).build() : arg).toList()));
            remainingDirectives.addFirst((Directive)newIndex);
            changed = true;
        }
        if ((via = GraphQlUtils.expectAtMostOneDirective(field, "via")) != null) {
            List<String> parentVarNames = GraphQlUtils.getArgAsStrings(via, "of");
            if (field.hasDirective("pattern")) {
                throw new RuntimeException("@via cannot be combined with @pattern");
            }
            if (field.hasDirective("join")) {
                throw new RuntimeException("@via cannot be combined with @join");
            }
            remainingDirectives.removeIf(x -> "via".equals(x.getName()));
            remainingDirectives.addFirst(Directive.newDirective().name("join").argument(Argument.newArgument((String)"parent", (Value)GraphQlUtils.toArrayValue(parentVarNames)).build()).build());
            remainingDirectives.addFirst(TransformExpandShorthands.newDirectivePattern("BIND(?from AS ?to)", "from", "to"));
            changed = true;
        }
        if (!(binds = field.getDirectives("bind")).isEmpty()) {
            remainingDirectives.removeIf(x -> "bind".equals(x.getName()));
            for (Directive bind : binds) {
                BindDirective parsed = BindDirective.PARSER.parser(bind);
                parsed = (BindDirective)parsed.expand(pm);
                Directive processed = parsed.toDirective();
                remainingDirectives.addLast(processed);
            }
            changed = true;
        }
        boolean bl = changed = TransformExpandShorthands.processFilter(field, (PrefixMapping)pming, remainingDirectives) || changed;
        if (changed) {
            LinkedList finalRemainingDirectives = remainingDirectives;
            Node replacementNode = (Node)transform.apply(node, finalRemainingDirectives);
            TreeTransformerUtil.changeNode(context, (Object)replacementNode);
        }
        return TraversalControl.CONTINUE;
    }

    private static boolean processFilter(DirectivesContainer<?> directives, PrefixMapping pming, LinkedList<Directive> remainingDirectives) {
        String exprStr;
        boolean changed = false;
        Directive filter = GraphQlUtils.expectAtMostOneDirective(directives, "filter");
        if (filter != null && (exprStr = GraphQlUtils.getArgAsString(filter, "if")) != null) {
            remainingDirectives.removeIf(x -> "filter".equals(x.getName()));
            Expr expr = ExprUtils.parse((String)exprStr, (PrefixMapping)pming);
            Directive newFilter = filter.transform(builder -> builder.arguments(filter.getArguments().stream().map(arg -> "if".equals(arg.getName()) ? Argument.newArgument((String)"if", (Value)StringValue.of((String)ExprUtils.fmtSPARQL((Expr)expr))).build() : arg).toList()));
            remainingDirectives.addFirst(newFilter);
            changed = true;
        }
        return changed;
    }

    public static String processVocab(DirectivesContainer<?> directives, TraverserContext<Node> context) {
        VocabDirective vocab = null;
        if (!context.isVisited()) {
            vocab = XGraphQlUtils.parseVocab(directives);
            if (vocab != null) {
                context.setVar(VocabDirective.class, (Object)vocab);
            }
        } else {
            vocab = (VocabDirective)context.getVar(VocabDirective.class);
        }
        if (vocab == null) {
            context.getVarFromParents(VocabDirective.class);
        }
        String result = vocab == null ? null : vocab.getIri();
        return result;
    }

    public static Directive newDirectiveSource(String effectiveIri) {
        Objects.requireNonNull(effectiveIri);
        Directive p = Directive.newDirective().name("source").argument(Argument.newArgument((String)"of", (Value)StringValue.of((String)("?s a <" + effectiveIri + ">"))).build()).build();
        return p;
    }

    public static Directive newDirectivePattern(String effectiveIri, boolean isForward) {
        Objects.requireNonNull(effectiveIri);
        String src = isForward ? "s" : "o";
        String tgt = isForward ? "o" : "s";
        Directive result = TransformExpandShorthands.newDirectivePattern("?s <" + effectiveIri + "> ?o", src, tgt);
        return result;
    }

    public static Directive newDirectivePattern(String pattern, String src, String tgt) {
        Directive p = Directive.newDirective().name("pattern").argument(Argument.newArgument((String)"of", (Value)StringValue.of((String)pattern)).build()).argument(Argument.newArgument((String)"from", (Value)StringValue.of((String)src)).build()).argument(Argument.newArgument((String)"to", (Value)StringValue.of((String)tgt)).build()).build();
        return p;
    }

    @Override
    public TraversalControl visitFragmentSpreadActual(FragmentSpread node, TraverserContext<Node> context) {
        return TraversalControl.CONTINUE;
    }
}

