/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.List;
import org.aksw.jenax.graphql.sparql.v2.rewrite.JenaGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.util.PrefixMap2;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;

public abstract class NodeVisitorPrefixesBase
extends NodeVisitorStub {
    public static PrefixMap getEffectivePrefixMap(TraverserContext<Node> context) {
        PrefixMap result = (PrefixMap)context.getVar(PrefixMap2.class);
        if (result == null && (result = (PrefixMap)context.getVar(PrefixMap.class)) == null && (result = NodeVisitorPrefixesBase.getParentPrefixMapOrNull(context)) == null) {
            result = PrefixMapFactory.emptyPrefixMap();
        }
        return result;
    }

    public static PrefixMap getParentPrefixMapOrNull(TraverserContext<Node> context) {
        PrefixMap parentPrefixMap = (PrefixMap)context.getVarFromParents(PrefixMap2.class);
        if (parentPrefixMap == null) {
            parentPrefixMap = (PrefixMap)context.getVarFromParents(PrefixMap.class);
        }
        return parentPrefixMap;
    }

    protected void processPrefixes(DirectivesContainer<?> node, TraverserContext<Node> context) {
        PrefixMap parentPrefixMap = NodeVisitorPrefixesBase.getParentPrefixMapOrNull(context);
        List prefixDirectives = node.getDirectives("prefix");
        if (prefixDirectives != null) {
            PrefixMap prefixMap = PrefixMapFactory.create();
            for (Directive directive : prefixDirectives) {
                JenaGraphQlUtils.readPrefixDirective(directive, prefixMap);
            }
            context.setVar(PrefixMap.class, (Object)prefixMap);
            if (parentPrefixMap != null) {
                context.setVar(PrefixMap2.class, (Object)new PrefixMap2(parentPrefixMap, prefixMap));
            }
        }
    }

    public TraversalControl visitOperationDefinition(OperationDefinition node, TraverserContext<Node> context) {
        if (OperationDefinition.Operation.QUERY.equals((Object)node.getOperation())) {
            this.processPrefixes((DirectivesContainer<?>)node, context);
        }
        return super.visitOperationDefinition(node, context);
    }

    public final TraversalControl visitField(Field field, TraverserContext<Node> context) {
        this.processPrefixes((DirectivesContainer<?>)field, context);
        return this.visitFieldActual(field, context);
    }

    public final TraversalControl visitFieldDefinition(FieldDefinition fieldDefinition, TraverserContext<Node> context) {
        this.processPrefixes((DirectivesContainer<?>)fieldDefinition, context);
        return this.visitFieldDefinitionActual(fieldDefinition, context);
    }

    public TraversalControl visitInterfaceTypeDefinition(InterfaceTypeDefinition node, TraverserContext<Node> context) {
        this.processPrefixes((DirectivesContainer<?>)node, context);
        return this.visitInterfaceTypeDefinitionActual(node, context);
    }

    public TraversalControl visitObjectTypeDefinition(ObjectTypeDefinition node, TraverserContext<Node> context) {
        this.processPrefixes((DirectivesContainer<?>)node, context);
        return this.visitObjectTypeDefinitionActual(node, context);
    }

    public final TraversalControl visitInlineFragment(InlineFragment node, TraverserContext<Node> context) {
        this.processPrefixes((DirectivesContainer<?>)node, context);
        return this.visitInlineFragmentActual(node, context);
    }

    public TraversalControl visitFragmentSpread(FragmentSpread node, TraverserContext<Node> context) {
        this.processPrefixes((DirectivesContainer<?>)node, context);
        return this.visitFragmentSpreadActual(node, context);
    }

    public abstract TraversalControl visitFieldActual(Field var1, TraverserContext<Node> var2);

    public abstract TraversalControl visitInlineFragmentActual(InlineFragment var1, TraverserContext<Node> var2);

    public abstract TraversalControl visitFragmentSpreadActual(FragmentSpread var1, TraverserContext<Node> var2);

    public abstract TraversalControl visitFieldDefinitionActual(FieldDefinition var1, TraverserContext<Node> var2);

    public abstract TraversalControl visitObjectTypeDefinitionActual(ObjectTypeDefinition var1, TraverserContext<Node> var2);

    public abstract TraversalControl visitInterfaceTypeDefinitionActual(InterfaceTypeDefinition var1, TraverserContext<Node> var2);
}

