/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.util;

import graphql.com.google.common.collect.ListMultimap;
import graphql.com.google.common.collect.Multimap;
import graphql.com.google.common.collect.Multimaps;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.AstPrinter;
import graphql.language.AstTransformer;
import graphql.language.BooleanValue;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.ScalarValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jenax.graphql.sparql.v2.util.NodeValueUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.NodeValue;

public class GraphQlUtils {
    public static <T extends graphql.language.Node<T>> T replaceDirectivesOld(T node, TraverserContext<graphql.language.Node> context, BiFunction<T, List<Directive>, T> transform, LinkedList<Directive> remainingDirectives) {
        LinkedList<Directive> finalRemainingDirectives = remainingDirectives;
        graphql.language.Node replacementNode = (graphql.language.Node)transform.apply(node, finalRemainingDirectives);
        TreeTransformerUtil.changeNode(context, (Object)replacementNode);
        return (T)replacementNode;
    }

    public static <T extends graphql.language.Node<T>> T replaceDirectives(T node, TraverserContext<graphql.language.Node> context, Function<T, Function<List<Directive>, T>> transform, List<Directive> remainingDirectives) {
        List<Directive> finalRemainingDirectives = remainingDirectives;
        Function<List<Directive>, List<Directive>> factory = transform.apply(node);
        graphql.language.Node replacementNode = (graphql.language.Node)factory.apply(finalRemainingDirectives);
        TreeTransformerUtil.changeNode(context, (Object)replacementNode);
        return (T)replacementNode;
    }

    public static Function<List<Directive>, Field> directivesSetterField(Field node) {
        return newDirectives -> node.transform(builder -> builder.directives(newDirectives));
    }

    public static Function<List<Directive>, FieldDefinition> directivesSetterFieldDefinition(FieldDefinition node) {
        return newDirectives -> node.transform(builder -> builder.directives(newDirectives));
    }

    public static boolean hasQueryDirective(Document document, String directiveName) {
        List<Directive> matches = GraphQlUtils.getQueryDirectives(document, directiveName);
        boolean result = !matches.isEmpty();
        return result;
    }

    public static List<Directive> getQueryDirectives(Document document, String directiveName) {
        List<Object> result = document != null ? document.getDefinitionsOfType(OperationDefinition.class).stream().filter(od -> OperationDefinition.Operation.QUERY.equals((Object)od.getOperation())).flatMap(od -> od.getDirectives(directiveName).stream()).collect(Collectors.toList()) : List.of();
        return result;
    }

    public static Optional<graphql.language.Node<?>> tryGetNode(graphql.language.Node<?> node, String ... path) {
        graphql.language.Node result = node;
        for (String segment : path) {
            if (result == null) break;
            result = result.getNamedChildren().getChildOrNull(segment);
        }
        return Optional.ofNullable(result);
    }

    public static Number getNumber(graphql.language.Node<?> node, String ... path) {
        return GraphQlUtils.tryGetNode(node, path).map(GraphQlUtils::toNumber).orElse(null);
    }

    public static Long getLong(graphql.language.Node<?> node, String ... path) {
        Number number = GraphQlUtils.getNumber(node, path);
        return number == null ? null : Long.valueOf(number.longValue());
    }

    public static String getString(graphql.language.Node<?> node, String ... path) {
        return GraphQlUtils.tryGetNode(node, path).map(GraphQlUtils::toNodeValue).map(NodeValue::asNode).map(Node::getLiteralLexicalForm).orElse(null);
    }

    public static NodeValue toNodeValue(graphql.language.Node<?> node) {
        NodeValue result = null;
        if (node instanceof IntValue) {
            result = NodeValue.makeInteger((BigInteger)((IntValue)node).getValue());
        } else if (node instanceof FloatValue) {
            result = NodeValue.makeDecimal((BigDecimal)((FloatValue)node).getValue());
        } else if (node instanceof BooleanValue) {
            result = NodeValue.makeBoolean((boolean)((BooleanValue)node).isValue());
        } else if (node instanceof StringValue) {
            result = NodeValue.makeString((String)((StringValue)node).getValue());
        } else if (node instanceof EnumValue) {
            result = NodeValue.makeString((String)((EnumValue)node).getName());
        }
        return result;
    }

    public static ScalarValue<?> toScalarValue(NodeValue nv) {
        StringValue result;
        if (nv.isString()) {
            result = StringValue.newStringValue((String)nv.getString()).build();
        } else if (nv.isInteger()) {
            result = IntValue.newIntValue((BigInteger)nv.getInteger()).build();
        } else if (nv.isBoolean()) {
            result = BooleanValue.newBooleanValue((boolean)nv.getBoolean()).build();
        } else if (nv.isDecimal()) {
            result = FloatValue.newFloatValue((BigDecimal)nv.getDecimal()).build();
        } else {
            throw new UnsupportedOperationException("Cannot convert: " + String.valueOf(nv));
        }
        return result;
    }

    public static Boolean getArgAsBoolean(Directive directive, String argName) {
        Boolean result = GraphQlUtils.getArgAsBoolean(directive, argName, null);
        return result;
    }

    public static String getArgAsString(Directive directive, String argName) {
        String result = GraphQlUtils.toString(GraphQlUtils.getValue(directive.getArgument(argName)));
        return result;
    }

    public static List<String> getArgAsStrings(Directive directive, String argName) {
        List<String> list;
        Value<?> raw = GraphQlUtils.getValue(directive.getArgument(argName));
        if (raw == null) {
            list = null;
        } else if (raw instanceof ArrayValue) {
            ArrayValue arr = (ArrayValue)raw;
            list = arr.getValues().stream().map(v -> GraphQlUtils.toString(v)).toList();
        } else {
            list = List.of(GraphQlUtils.toString(raw));
        }
        List<String> result = list;
        return result;
    }

    public static String toString(graphql.language.Node<?> node) {
        NodeValue nv = GraphQlUtils.toNodeValue(node);
        String result = nv == null ? null : nv.getString();
        return result;
    }

    public static Boolean toBoolean(graphql.language.Node<?> node) {
        NodeValue nv = GraphQlUtils.toNodeValue(node);
        Boolean result = nv == null ? null : Boolean.valueOf(nv.getBoolean());
        return result;
    }

    public static Number toNumber(graphql.language.Node<?> node) {
        NodeValue nv = GraphQlUtils.toNodeValue(node);
        Number result = nv == null ? (Number)null : (Number)NodeValueUtils.getNumber(nv);
        return result;
    }

    public static Long toLong(graphql.language.Node<?> node) {
        Number number = GraphQlUtils.toNumber(node);
        Long result = number == null ? null : Long.valueOf(number.longValue());
        return result;
    }

    public static Multimap<String, Value<?>> indexArguments(Field field) {
        ListMultimap result = Multimaps.transformValues((ListMultimap)Multimaps.index((Iterable)field.getArguments(), Argument::getName), Argument::getValue);
        return result;
    }

    public static Multimap<String, Value<?>> indexValues(ObjectValue field) {
        ListMultimap result = Multimaps.transformValues((ListMultimap)Multimaps.index((Iterable)field.getObjectFields(), ObjectField::getName), ObjectField::getValue);
        return result;
    }

    public static Value<?> getValue(Argument arg) {
        return arg == null ? null : arg.getValue();
    }

    public static Long getArgAsLong(Field field, String name, Map<String, Value<?>> assignments) {
        return GraphQlUtils.getArgAsLong(field.getArguments(), name, assignments);
    }

    public static Long getArgAsLong(List<Argument> arguments, String name, Map<String, Value<?>> assignments) {
        return GraphQlUtils.toLong(GraphQlUtils.resolveValue(GraphQlUtils.getValue(GraphQlUtils.findArgument(arguments, name)), assignments));
    }

    public static Argument findArgument(List<Argument> arguments, String name) {
        return arguments.stream().filter(arg -> name.equals(arg.getName())).findFirst().orElse(null);
    }

    public static Value<?> getArgValue(Directive directive, String argName) {
        Argument arg = directive.getArgument(argName);
        Value result = arg == null ? null : arg.getValue();
        return result;
    }

    public static String getArgValueAsString(Directive directive, String argName, Map<String, Value<?>> assignments) {
        String result = GraphQlUtils.toString(GraphQlUtils.resolveValue(GraphQlUtils.getValue(directive.getArgument(argName)), assignments));
        return result;
    }

    public static Boolean getArgAsBoolean(Directive directive, String argName, Map<String, Value<?>> assignments) {
        Boolean result = GraphQlUtils.toBoolean(GraphQlUtils.resolveValue(GraphQlUtils.getValue(directive.getArgument(argName)), assignments));
        return result;
    }

    public static Value<?> resolveValue(Value<?> value, Map<String, Value<?>> assignments) {
        Value<?> result;
        if (value instanceof VariableReference) {
            VariableReference ref = (VariableReference)value;
            String varName = ref.getName();
            result = assignments.get(varName);
        } else {
            result = value;
        }
        return result;
    }

    public static Map<String, Value<?>> mapToGraphQl(Map<String, Node> assignments) {
        Map<String, Value> result = assignments == null ? null : assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> GraphQlUtils.toScalarValue(NodeValue.makeNode((Node)((Node)v.getValue())))));
        return result;
    }

    public static Map<String, Node> mapToJena(Map<String, Value<?>> assignments) {
        Map<String, Node> result = assignments == null ? null : assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> GraphQlUtils.toNodeValue((graphql.language.Node)v.getValue()).asNode()));
        return result;
    }

    public static Document applyTransform(Document doc, NodeVisitorStub visitor) {
        AstTransformer transformer = new AstTransformer();
        graphql.language.Node node = transformer.transform((graphql.language.Node)doc, (NodeVisitor)visitor);
        Document result = (Document)node;
        return result;
    }

    public static void println(PrintStream printStream, Document doc) {
        String str = AstPrinter.printAst((graphql.language.Node)doc);
        printStream.println(str);
    }

    public static Directive expectAtMostOneDirective(DirectivesContainer<?> container, String name) {
        List directives = container.getDirectives(name);
        if (directives.size() > 1) {
            System.err.println("Only one directive expected: " + name);
        }
        return directives.isEmpty() ? null : (Directive)directives.get(directives.size() - 1);
    }

    public static ArrayValue toArrayValue(List<String> strs) {
        return ArrayValue.newArrayValue().values(strs.stream().map(x -> StringValue.of((String)x)).toList()).build();
    }

    public static Argument newArgString(String name, String value) {
        return value == null ? null : Argument.newArgument().name(name).value((Value)StringValue.of((String)value)).build();
    }

    public static Argument newArgBoolean(String name, Boolean value) {
        return value == null ? null : Argument.newArgument().name(name).value((Value)BooleanValue.of((boolean)value)).build();
    }

    public static Argument newArgString(String name, List<String> values) {
        return values == null ? null : Argument.newArgument().name(name).value((Value)GraphQlUtils.toArrayValue(values)).build();
    }

    public static Directive newDirective(String name, Argument ... arguments) {
        Directive.Builder builder = Directive.newDirective().name(name);
        for (Argument arg : arguments) {
            if (arg == null) continue;
            builder = builder.argument(arg);
        }
        return builder.build();
    }

    public static void removeDirectivesByName(Collection<Directive> directives, String name) {
        directives.removeIf(d -> d.getName().equals(name));
    }
}

