/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.schema;

import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNode;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNodeOverObjectTypeDefinition;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNodeOverScalarTypeDefinition;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;

public class SchemaNavigator {
    protected TypeDefinitionRegistry schema;
    protected Map<String, SchemaNode> typeNameToSchemaNode = new HashMap<String, SchemaNode>();
    protected PrefixMap globalPrefixMap;
    protected volatile PrefixMap queryPrefixMap;
    protected PrefixMap basePrefixMap;

    public SchemaNavigator(TypeDefinitionRegistry schema, PrefixMap globalPrefixMap) {
        this.schema = schema;
        this.globalPrefixMap = globalPrefixMap;
    }

    public PrefixMap getGlobalPrefixMap() {
        return this.globalPrefixMap;
    }

    public PrefixMap getBasePrefixMap() {
        return this.basePrefixMap;
    }

    public SchemaNode getOrCreateSchemaNode(String typeName) {
        TypeDefinition typeDefinition = (TypeDefinition)this.schema.getType(typeName).orElseThrow(() -> new RuntimeException("No type: " + typeName));
        if (!(typeDefinition instanceof ObjectTypeDefinition)) {
            if (typeDefinition instanceof ScalarTypeDefinition) {
                ScalarTypeDefinition stt = (ScalarTypeDefinition)typeDefinition;
                return new SchemaNodeOverScalarTypeDefinition(this, stt);
            }
            throw new RuntimeException("Currently unsupported type definition: " + String.valueOf(typeDefinition));
        }
        ObjectTypeDefinition otd = (ObjectTypeDefinition)typeDefinition;
        SchemaNode result = this.typeNameToSchemaNode.computeIfAbsent(typeName, t -> new SchemaNodeOverObjectTypeDefinition(this, otd));
        return result;
    }

    public static SchemaNavigator of(TypeDefinitionRegistry schema) {
        return new SchemaNavigator(schema, PrefixMapFactory.emptyPrefixMap());
    }
}

