/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.io;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import graphql.com.google.common.base.Preconditions;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlProcessorSettings;

public class GraphQlJsonUtils {
    public static void configureFromJson(GraphQlProcessorSettings<?> processorBuilder, String jsonRequest) {
        GraphQlJsonUtils.configureFromJson(processorBuilder, new Gson(), jsonRequest);
    }

    public static void configureFromJson(GraphQlProcessorSettings<?> processorBuilder, Gson gson, String jsonRequest) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonRequest, JsonObject.class);
        GraphQlJsonUtils.configureFromJson(processorBuilder, jsonObject);
    }

    public static void configureFromJson(GraphQlProcessorSettings<?> processorBuilder, JsonObject jsonObject) {
        Preconditions.checkArgument((jsonObject != null ? 1 : 0) != 0, (Object)"Expected a GraphQL document in JSON but got null");
        JsonElement queryElt = jsonObject.get("query");
        Preconditions.checkArgument((queryElt != null ? 1 : 0) != 0, (Object)"JSON object does not have a query field");
        Preconditions.checkArgument((boolean)queryElt.isJsonPrimitive(), (Object)"Value for 'query' is not a string");
        JsonPrimitive primitive = queryElt.getAsJsonPrimitive();
        Preconditions.checkArgument((boolean)primitive.isString(), (Object)"Value for 'query' must be a string");
        String queryStr = primitive.getAsString();
        processorBuilder.document(queryStr);
    }
}

