/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.exec.api.high;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import graphql.language.Document;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.function.Function;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExec;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlResultWriterImpl;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonProviderGson;
import org.aksw.jenax.graphql.sparql.v2.io.GraphQlIoBridge;
import org.aksw.jenax.graphql.sparql.v2.io.JsonWriterAdapter;
import org.aksw.jenax.graphql.sparql.v2.io.JsonWriterGson;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriterMapperImpl;
import org.aksw.jenax.graphql.sparql.v2.util.GraphQlUtils;
import org.apache.jena.graph.Node;

public class GraphQlExecUtils {
    public static boolean isFormatPretty(GraphQlExec<?> exec) {
        Document document = exec.getDelegate().getProcessor().getPreprocessedDocument();
        return GraphQlUtils.hasQueryDirective(document, "pretty");
    }

    public static void write(OutputStream out, GraphQlExec<String> exec) throws IOException {
        boolean isFormatPretty = GraphQlExecUtils.isFormatPretty(exec);
        if (isFormatPretty) {
            GraphQlExecUtils.writePretty(out, exec);
        } else {
            GraphQlExecUtils.writeCompact(out, exec);
        }
    }

    public static void writeCompact(OutputStream out, GraphQlExec<String> exec) throws IOException {
        GraphQlExecUtils.write(out, exec, new GsonBuilder().serializeNulls().create());
    }

    public static void writePretty(OutputStream out, GraphQlExec<String> exec) throws IOException {
        GraphQlExecUtils.write(out, exec, new GsonBuilder().serializeNulls().setPrettyPrinting().create());
    }

    public static void write(OutputStream out, GraphQlExec<String> exec, Gson gson) throws IOException {
        ObjectNotationWriterMapperImpl<String, String, Node, JsonPrimitive> writer;
        JsonWriterGson destination = JsonWriterAdapter.of(gson.newJsonWriter((Writer)new OutputStreamWriter(out)), gson);
        GonProviderGson gonProvider = GonProviderGson.of();
        Function<String, String> keyMapper = x -> x;
        Function<Node, JsonElement> valueMapper = GraphQlIoBridge::nodeToJsonElement;
        ObjectNotationWriterMapperImpl<String, String, Node, JsonPrimitive> front = writer = new ObjectNotationWriterMapperImpl<String, String, Node, JsonPrimitive>(destination, gonProvider, keyMapper, valueMapper);
        try {
            new GraphQlResultWriterImpl(gson).write(front, exec);
            out.write(10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

