/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.context;

import graphql.language.Directive;
import java.util.Optional;
import org.aksw.jenax.graphql.sparql.v2.context.DirectiveParser;
import org.aksw.jenax.graphql.sparql.v2.context.DirectiveParserImpl;
import org.aksw.jenax.graphql.sparql.v2.context.PrefixExpandable;
import org.aksw.jenax.graphql.sparql.v2.util.GraphQlUtils;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.util.ExprUtils;

public record BindDirective(String exprStr, String varName, Boolean isTarget) implements PrefixExpandable<BindDirective>
{
    public static final DirectiveParser<BindDirective> PARSER = new DirectiveParserImpl<BindDirective>(BindDirective.class, "bind", false, BindDirective::parse);

    public static BindDirective parse(Directive directive) {
        String exprStr = GraphQlUtils.getArgAsString(directive, "of");
        String as = GraphQlUtils.getArgAsString(directive, "as");
        boolean isTarget = Optional.ofNullable(GraphQlUtils.getArgAsBoolean(directive, "target")).orElse(false);
        BindDirective result = new BindDirective(exprStr, as, isTarget);
        return result;
    }

    public Var getVar() {
        return this.varName == null ? null : Var.alloc((String)this.varName);
    }

    public Expr parseExpr() {
        Expr result = ExprUtils.parse((String)this.exprStr);
        return result;
    }

    @Override
    public BindDirective expand(PrefixMapping pm) {
        Expr expr = ExprUtils.parse((String)this.exprStr, (PrefixMapping)pm);
        String newExprStr = ExprUtils.fmtSPARQL((Expr)expr);
        return new BindDirective(newExprStr, this.varName, this.isTarget);
    }

    public Directive toDirective() {
        return GraphQlUtils.newDirective("bind", GraphQlUtils.newArgString("of", this.exprStr), GraphQlUtils.newArgString("as", this.varName), GraphQlUtils.newArgBoolean("target", this.isTarget));
    }
}

