/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccJsonErrorHandler;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccState;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateGon;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.AccStatePropertyBase;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonProvider;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriter;

public class AccStateProperty<I, E, K, V>
extends AccStatePropertyBase<I, E, K, V> {
    protected AccStateGon<I, E, K, V> targetAcc;
    protected boolean skipOutputStartedHere = false;
    protected long seenTargetCount = 0L;
    protected Object value;

    public AccStateProperty(Object matchStateId, K memberKey, AccStateGon<I, E, K, V> targetAcc, boolean isSingle) {
        super(matchStateId, memberKey, isSingle);
        this.targetAcc = targetAcc;
    }

    @Override
    public void beginActual() throws IOException {
        this.seenTargetCount = 0L;
        this.skipOutputStartedHere = false;
        if (!this.skipOutput) {
            if (this.context.isMaterialize()) {
                GonProvider gonProvider = this.context.getGonProvider();
                Object object = this.value = this.isSingle ? gonProvider.newNull() : gonProvider.newArray();
            }
            if (this.context.isSerialize()) {
                ObjectNotationWriter writer = this.context.getJsonWriter();
                writer.name(this.memberKey);
                if (!this.isSingle) {
                    writer.beginArray();
                }
            }
        }
    }

    @Override
    public AccStateGon<I, E, K, V> transitionActual(Object inputStateId, I input, E env) throws IOException {
        AccStateGon<I, E, K, V> result = null;
        if (Objects.equals(this.matchStateId, inputStateId)) {
            boolean isTooMany;
            ++this.seenTargetCount;
            boolean bl = isTooMany = this.isSingle && this.seenTargetCount > 1L;
            if (isTooMany) {
                this.skipOutputStartedHere = true;
                AccJsonErrorHandler errorHandler = this.context.getErrorHandler();
                if (errorHandler != null) {
                    throw new RuntimeException("Error handler not yet implemented");
                }
            }
            this.targetAcc.begin(null, input, env, this.skipOutput || this.skipOutputStartedHere);
            result = this.targetAcc;
        }
        return result;
    }

    @Override
    public void endActual() throws IOException {
        if (!this.skipOutput) {
            if (this.context.isMaterialize()) {
                GonProvider gonProvider = this.context.getGonProvider();
                if (this.parent != null) {
                    Object elt = this.value == null ? gonProvider.newNull() : this.value;
                    AccState valueParent = this.getParent();
                    throw new RuntimeException("materialization no longer supported");
                }
            }
            if (this.context.isSerialize()) {
                ObjectNotationWriter jsonWriter = this.context.getJsonWriter();
                if (!this.isSingle) {
                    jsonWriter.endArray();
                } else if (this.seenTargetCount == 0L) {
                    jsonWriter.nullValue();
                }
            }
        }
    }

    public String toString() {
        return "AccStateProperty(matches: " + String.valueOf(this.matchStateId) + ", currentInput: " + String.valueOf(this.currentInput) + ", " + String.valueOf(this.targetAcc) + ")";
    }

    @Override
    public Iterator<? extends AccStateGon<I, E, K, V>> children() {
        return List.of(this.targetAcc).iterator();
    }
}

