/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.util;

import java.math.BigDecimal;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;

public class NodeValueUtils {
    public static Number getNumber(NodeValue expr) {
        Object obj = NodeValueUtils.getValue(expr);
        Number result = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
        return result;
    }

    public static Object getValue(NodeValue expr) {
        if (expr == null) {
            return Expr.NONE;
        }
        if (expr.isIRI()) {
            return expr.asNode().getURI();
        }
        if (expr.isBoolean()) {
            return expr.getBoolean();
        }
        if (expr.isNumber()) {
            if (expr.isDecimal()) {
                BigDecimal d = expr.getDecimal();
                if (d.scale() > 0) {
                    return d.doubleValue();
                }
                return d.intValue();
            }
            if (expr.isDouble()) {
                return expr.getDouble();
            }
            if (expr.isFloat()) {
                return Float.valueOf(expr.getFloat());
            }
            return expr.getDecimal().longValue();
        }
        if (expr.isString()) {
            return expr.getString();
        }
        if (expr.isDateTime()) {
            return expr.getDateTime();
        }
        throw new RuntimeException("Unknow datatype of constant: " + String.valueOf(expr));
    }
}

