/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.fuseki.mod.graphql;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.aksw.jenax.fuseki.mod.graphql.ResourceSource;
import org.aksw.jenax.fuseki.mod.graphql.ResourceSourceFromStreamManager;
import org.aksw.jenax.fuseki.mod.graphql.ResourceSourceStatic;
import org.apache.jena.atlas.web.TypedInputStream;

public class HttpServletOverResource
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ResourceSource resource;

    public HttpServletOverResource(ResourceSource resource) {
        Objects.requireNonNull(resource);
        this.resource = resource;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (TypedInputStream tin = this.resource.open();){
            String contentType = tin.getContentType();
            if (contentType != null) {
                resp.setContentType(contentType);
            }
            ServletOutputStream out = resp.getOutputStream();
            tin.transferTo((OutputStream)out);
        }
    }

    public static HttpServletOverResource of(ResourceSource resource) {
        return new HttpServletOverResource(resource);
    }

    public static HttpServletOverResource of(String contentType, byte[] payload) {
        return HttpServletOverResource.of(new ResourceSourceStatic(contentType, payload));
    }

    public static HttpServletOverResource ofNamedResource(String contentType, String resourceName) {
        return HttpServletOverResource.of(new ResourceSourceFromStreamManager(contentType, resourceName));
    }
}

