/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.graphql;

import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static String getExternalForm(Class<?> clazz) {
        String rawFilename;
        String filename;
        Path parent;
        Path warPath;
        Path path;
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        String externalForm = location.toExternalForm();
        if (logger.isDebugEnabled()) {
            logger.debug("Trying to resolve webapp by starting from location (external form): " + externalForm);
        }
        try {
            path = Paths.get(location.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (externalForm.endsWith("/classes/")) {
            Path webappFolder = path.resolve("../../src/main/webapp").normalize();
            if (Files.exists(webappFolder, new LinkOption[0])) {
                externalForm = webappFolder.toString();
            }
        } else if (externalForm.endsWith("-classes.jar") && Files.exists(warPath = (parent = path.getParent()).resolve(filename = (rawFilename = String.valueOf(path.getFileName())).replace("-classes.jar", ".war")), new LinkOption[0])) {
            externalForm = warPath.toString();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Resolved webapp location to: " + externalForm);
        }
        return externalForm;
    }
}

