/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.graphql;

import graphql.language.AstPrinter;
import graphql.language.Document;
import graphql.language.Node;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.aksw.jenax.graphql.sparql.v2.schema.GraphQlSchemaUtils;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNavigator;
import org.aksw.jenax.web.servlet.graphql.GraphQlUi;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.sys.FusekiAutoModule;
import org.apache.jena.fuseki.mod.graphql.GraphQlQueryService;
import org.apache.jena.fuseki.mod.graphql.HttpServletStaticPayload;
import org.apache.jena.fuseki.mod.graphql.IO2;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class FMod_GraphQl
implements FusekiAutoModule {
    public static final String NS = "https://w3id.org/aksw/norse#graphql.";
    public static final String OP_NAME = "https://w3id.org/aksw/norse#graphql.fmod.op";
    public static final Symbol SYM_GRAPHQL_SCHEMA_NAVIGATOR = Symbol.create((String)"https://w3id.org/aksw/norse#graphql.graphQlSchemaNavigator");
    public static final Symbol SYM_GRAPHQL_SCHEMA = Symbol.create((String)"https://w3id.org/aksw/norse#graphql.schemaFile");
    private Operation graphQlQueryOperation = null;
    private static byte[] jsBundleBytes = null;

    public static String getGraphQlSchemaFile(Context cxt) {
        return cxt == null ? null : cxt.getAsString(SYM_GRAPHQL_SCHEMA);
    }

    public static void setGraphQlSchemaNavigator(Context cxt, SchemaNavigator schemaNavigator) {
        cxt.set(SYM_GRAPHQL_SCHEMA_NAVIGATOR, (Object)schemaNavigator);
    }

    public static SchemaNavigator getGraphQlSchemaNavigator(Context cxt) {
        return cxt == null ? null : (SchemaNavigator)cxt.get(SYM_GRAPHQL_SCHEMA_NAVIGATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] loadJsBundle() {
        if (jsBundleBytes != null) return jsBundleBytes;
        Class<FMod_GraphQl> clazz = FMod_GraphQl.class;
        synchronized (FMod_GraphQl.class) {
            if (jsBundleBytes != null) return jsBundleBytes;
            String jsBundleName = "static/graphql/mui/graphql.bundle.js";
            try {
                jsBundleBytes = IO2.readResourceAsBytes(GraphQlUi.class, jsBundleName);
            }
            catch (IOException e) {
                throw new FusekiException((Throwable)e);
            }
            return jsBundleBytes;
        }
    }

    public String name() {
        return "GraphQL query service";
    }

    public void start() {
        Fuseki.configLog.info(this.name() + ": Add GraphQL operation into global registry.");
        this.graphQlQueryOperation = Operation.alloc((String)OP_NAME, (String)"graphql", (String)"GraphQL query service");
    }

    public void prepare(FusekiServer.Builder builder, Set<String> datasetNames, Model configModel) {
        Fuseki.configLog.info(this.name() + ": Module adds GraphQL servlet");
        builder.registerOperation(this.graphQlQueryOperation, (ActionService)new GraphQlQueryService());
    }

    public void configured(FusekiServer.Builder builder, DataAccessPointRegistry dapRegistry, Model configModel) {
        List daps = dapRegistry.accessPoints();
        for (DataAccessPoint dap : daps) {
            this.configDataAccessPoint(builder, dap, configModel);
        }
        boolean registerForQueryEndpoints = true;
        if (registerForQueryEndpoints) {
            this.registerGraphQlEndpointsForSparqlQueryEndpoints(builder, dapRegistry);
        }
    }

    private void registerGraphQlEndpointsForSparqlQueryEndpoints(FusekiServer.Builder builder, DataAccessPointRegistry dapRegistry) {
        List oldDaps = dapRegistry.accessPoints();
        ArrayList<DataAccessPoint> newDaps = new ArrayList<DataAccessPoint>(oldDaps.size());
        for (DataAccessPoint dap2 : oldDaps) {
            DataService dataService = dap2.getDataService();
            List queryEndpoints = Optional.ofNullable(dataService.getEndpoints(Operation.Query)).orElse(List.of());
            ArrayList<Endpoint> graphQlEndpoints = new ArrayList<Endpoint>();
            for (Endpoint queryEndpoint : queryEndpoints) {
                String queryEndpointName = queryEndpoint.getName();
                Object baseName = queryEndpointName.isBlank() ? "" : queryEndpointName + "-";
                AuthPolicy authPolicy = queryEndpoint.getAuthPolicy();
                Endpoint graphQlEndpoint = Endpoint.create().operation(this.graphQlQueryOperation).endpointName((String)baseName + "graphql").authPolicy(authPolicy).build();
                graphQlEndpoints.add(graphQlEndpoint);
            }
            DataService.Builder dsb = DataService.newBuilder((DataService)dataService);
            graphQlEndpoints.forEach(arg_0 -> ((DataService.Builder)dsb).addEndpoint(arg_0));
            DataService dSrv = dsb.build();
            DataAccessPoint newDap = new DataAccessPoint(dap2.getName(), dSrv);
            newDaps.add(newDap);
            String name = dap2.getName();
            this.registerJsServlet(builder, name);
        }
        newDaps.forEach(dap -> {
            dapRegistry.remove((Object)dap.getName());
            dapRegistry.register(dap);
        });
    }

    protected void registerJsServlet(FusekiServer.Builder builder, String name) {
        byte[] jsBundleBytes = FMod_GraphQl.loadJsBundle();
        String resServletName = name + "/graphql.bundle.js";
        Fuseki.configLog.info(this.name() + ": Registering " + resServletName);
        builder.addServlet(resServletName, (HttpServlet)new HttpServletStaticPayload("text/javascript", jsBundleBytes));
    }

    public void configDataAccessPoint(DataAccessPoint dap, Model configModel) {
        throw new RuntimeException("Should not be called.");
    }

    public void configDataAccessPoint(FusekiServer.Builder builder, DataAccessPoint dap, Model configModel) {
        super.configDataAccessPoint(dap, configModel);
        List endpoints = Optional.ofNullable(dap.getDataService().getEndpoints(this.graphQlQueryOperation)).orElse(List.of());
        for (Endpoint endpoint : endpoints) {
            FMod_GraphQl.processGraphQlSchema(builder, dap, endpoint);
        }
        String name = dap.getName();
        this.registerJsServlet(builder, name);
    }

    public static void processGraphQlSchema(FusekiServer.Builder builder, DataAccessPoint dap, Endpoint endpoint) {
        Context cxt = endpoint.getContext();
        String graphQlSchemaFile = FMod_GraphQl.getGraphQlSchemaFile(cxt);
        if (graphQlSchemaFile != null) {
            byte[] graphQlSchemaDocBytes;
            TypeDefinitionRegistry graphQlSchema;
            try {
                Document graphQlSchemaDoc = GraphQlSchemaUtils.loadSchema((String)graphQlSchemaFile);
                SchemaParser schemaParser = new SchemaParser();
                graphQlSchema = schemaParser.buildRegistry(graphQlSchemaDoc);
                String graphQlSchemaPrettyStr = AstPrinter.printAst((Node)graphQlSchemaDoc);
                graphQlSchemaDocBytes = graphQlSchemaPrettyStr.getBytes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String dapName = dap.getName();
            String servletName = dapName + "/schema.graphql";
            builder.addServlet(servletName, (HttpServlet)new HttpServletStaticPayload("application/graphql", graphQlSchemaDocBytes));
            SchemaNavigator graphqlSchemaNavigator = SchemaNavigator.of((TypeDefinitionRegistry)graphQlSchema);
            FMod_GraphQl.setGraphQlSchemaNavigator(cxt, graphqlSchemaNavigator);
        }
    }

    public void serverAfterStarting(FusekiServer server) {
        Fuseki.configLog.info(this.name() + ": Customized server start on port " + server.getHttpPort());
    }
}

