/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.graphql;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.sys.FusekiAutoModule;
import org.apache.jena.fuseki.mod.graphql.GraphQlQueryService;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.rdf.model.Model;

public class FMod_GraphQl
implements FusekiAutoModule {
    private Operation graphQlQueryOperation = null;

    public String name() {
        return "GraphQL query service";
    }

    public void start() {
        Fuseki.configLog.info(this.name() + ": Add GraphQL operation into global registry.");
        this.graphQlQueryOperation = Operation.alloc((String)"http://org.apache.jena/graphql-service", (String)"graphql", (String)"GraphQL query service");
    }

    public void prepare(FusekiServer.Builder builder, Set<String> datasetNames, Model configModel) {
        Fuseki.configLog.info(this.name() + ": Module adds GraphQL servlet");
        builder.registerOperation(this.graphQlQueryOperation, (ActionService)new GraphQlQueryService());
        datasetNames.forEach(name -> builder.addEndpoint(name, "graphql", this.graphQlQueryOperation));
    }

    public void configured(FusekiServer.Builder serverBuilder, DataAccessPointRegistry dapRegistry, Model configModel) {
        super.configured(serverBuilder, dapRegistry, configModel);
        List<DataAccessPoint> daps = dapRegistry.accessPoints().stream().map(dap -> {
            Endpoint endpoint = Endpoint.create().operation(this.graphQlQueryOperation).endpointName("graphql").build();
            DataService dSrv = DataService.newBuilder((DataService)dap.getDataService()).addEndpoint(endpoint).build();
            return new DataAccessPoint(dap.getName(), dSrv);
        }).collect(Collectors.toList());
        daps.forEach(dap -> {
            dapRegistry.remove((Object)dap.getName());
            dapRegistry.register(dap);
        });
    }

    public void configDataAccessPoint(DataAccessPoint dap, Model configModel) {
        super.configDataAccessPoint(dap, configModel);
    }

    public void serverAfterStarting(FusekiServer server) {
        Fuseki.configLog.info(this.name() + ": Customized server start on port " + server.getHttpPort());
    }
}

