/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.graphql;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExec;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExecBuilder;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExecFactory;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExecUtils;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlProcessorSettings;
import org.aksw.jenax.graphql.sparql.v2.io.GraphQlJsonUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.servlets.BaseActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.exec.QueryExec;

public class GraphQlQueryService
extends BaseActionREST {
    protected void doGet(HttpAction action) {
        String resourceName = "graphql/mui/index.html";
        Object str = null;
        try (InputStream in = GraphQlQueryService.class.getClassLoader().getResourceAsStream(resourceName);){
            str = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FusekiException((Throwable)e);
        }
        if (str == null) {
            action.setResponseStatus(500);
            action.setResponseContentType("text/plain");
            str = "Failed to load classpath resource " + resourceName;
        } else {
            action.setResponseStatus(200);
            action.setResponseContentType("text/html");
        }
        try (ServletOutputStream out = action.getResponseOutputStream();){
            IOUtils.write((String)str, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FusekiException((Throwable)e);
        }
    }

    protected void doPost(HttpAction action) {
        String queryJsonStr;
        DatasetGraph dsg = action.getDataset();
        try (InputStream in = action.getRequestInputStream();){
            queryJsonStr = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e1) {
            throw new FusekiException((Throwable)e1);
        }
        Gson gson = new Gson();
        JsonObject queryJson = (JsonObject)gson.fromJson(queryJsonStr, JsonObject.class);
        GraphQlExecFactory qef = GraphQlExecFactory.of(() -> QueryExec.newBuilder().dataset(dsg));
        GraphQlExecBuilder builder = qef.newBuilder();
        GraphQlJsonUtils.configureFromJson((GraphQlProcessorSettings)builder, (JsonObject)queryJson);
        GraphQlExec exec = builder.buildForJson();
        action.beginRead();
        try {
            action.setResponseStatus(200);
            action.setResponseContentType("application/json");
            try (ServletOutputStream out = action.getResponseOutputStream();){
                GraphQlExecUtils.writePretty((OutputStream)out, (GraphQlExec)exec);
            }
        }
        catch (IOException e) {
            throw new FusekiException((Throwable)e);
        }
        finally {
            action.end();
        }
    }
}

