/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform;

import java.util.List;
import java.util.Map;
import org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform.ElementTransformer;
import org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform.ExprTransformApplyElementTransform;
import org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform.ExprTransformNodeElement;
import org.aksw.jenax.graphql.sparql.v2.util.backport.syntaxtransform.VarExprListUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.SortCondition;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class QueryTransformOps {
    public static Query transform(Query query, Map<Var, ? extends Node> substitutions) {
        ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(substitutions);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement((NodeTransform)nodeTransform, (ElementTransform)eltrans);
        return QueryTransformOps.transform(query, (ElementTransform)eltrans, (ExprTransform)exprTrans);
    }

    public static Query transform(Query query, ElementTransform transform, ExprTransform exprTransform) {
        Element el;
        Query q2 = QueryTransformOps.shallowCopy(query);
        QueryTransformOps.transformVarExprList(q2.getProject(), exprTransform);
        QueryTransformOps.transformVarExprList(q2.getGroupBy(), exprTransform);
        QueryTransformOps.transformExprList(q2.getHavingExprs(), exprTransform);
        if (q2.getOrderBy() != null) {
            QueryTransformOps.transformSortConditions(q2.getOrderBy(), exprTransform);
        }
        if (q2.hasAggregators()) {
            List eas = q2.getAggregators();
            for (int i = 0; i < eas.size(); ++i) {
                ExprAggregator before = (ExprAggregator)eas.get(i);
                ExprAggregator after = (ExprAggregator)before.apply(exprTransform);
                eas.set(i, after);
            }
        }
        if ((el = q2.getQueryPattern()) != null) {
            Element el2 = ElementTransformer.transform(el, transform, exprTransform);
            if (!(el2 instanceof ElementGroup)) {
                ElementGroup eg = new ElementGroup();
                eg.addElement(el2);
                el2 = eg;
            }
            q2.setQueryPattern(el2);
        }
        return q2;
    }

    public static Query transform(Query query, ElementTransform transform) {
        ExprTransformApplyElementTransform noop = new ExprTransformApplyElementTransform(transform);
        return QueryTransformOps.transform(query, transform, (ExprTransform)noop);
    }

    private static void transformExprList(List<Expr> exprList, ExprTransform exprTransform) {
        for (int i = 0; i < exprList.size(); ++i) {
            Expr e1 = exprList.get(0);
            Expr e2 = ExprTransformer.transform((ExprTransform)exprTransform, (Expr)e1);
            if (e2 == null || e2 == e1) continue;
            exprList.set(i, e2);
        }
    }

    private static void transformSortConditions(List<SortCondition> conditions, ExprTransform exprTransform) {
        for (int i = 0; i < conditions.size(); ++i) {
            SortCondition s1 = conditions.get(i);
            Expr e = ExprTransformer.transform((ExprTransform)exprTransform, (Expr)s1.expression);
            if (e == null || s1.expression.equals((Object)e)) continue;
            conditions.set(i, new SortCondition(e, s1.direction));
        }
    }

    private static void transformVarExprList(VarExprList varExprList, ExprTransform exprTransform) {
        VarExprList tmp = VarExprListUtils.transform(varExprList, exprTransform);
        VarExprListUtils.replace(varExprList, tmp);
    }

    public static Query shallowCopy(Query query) {
        QueryShallowCopy copy = new QueryShallowCopy();
        query.visit((QueryVisitor)copy);
        Query q2 = copy.newQuery;
        return q2;
    }

    static class QueryShallowCopy
    implements QueryVisitor {
        final Query newQuery = new Query();

        QueryShallowCopy() {
        }

        public void startVisit(Query query) {
            this.newQuery.setSyntax(query.getSyntax());
            if (query.explicitlySetBaseURI()) {
                this.newQuery.setBaseURI(query.getPrologue().getBaseURI());
            }
            this.newQuery.setQueryResultStar(query.isQueryResultStar());
            if (query.hasDatasetDescription()) {
                DatasetDescription desc = query.getDatasetDescription();
                for (String x : desc.getDefaultGraphURIs()) {
                    this.newQuery.addGraphURI(x);
                }
                for (String x : desc.getNamedGraphURIs()) {
                    this.newQuery.addNamedGraphURI(x);
                }
            }
            this.newQuery.getAggregators().addAll(query.getAggregators());
        }

        public void visitPrologue(Prologue prologue) {
            PrefixMapping pmap = new PrefixMappingImpl().setNsPrefixes(prologue.getPrefixMapping());
            this.newQuery.setPrefixMapping(pmap);
        }

        public void visitResultForm(Query q) {
        }

        public void visitSelectResultForm(Query query) {
            this.newQuery.setQuerySelectType();
            this.newQuery.setDistinct(query.isDistinct());
            VarExprList x = query.getProject();
            for (Var v : x.getVars()) {
                Expr expr = x.getExpr(v);
                if (expr == null) {
                    this.newQuery.addResultVar((Node)v);
                    continue;
                }
                this.newQuery.addResultVar((Node)v, expr);
            }
        }

        public void visitConstructResultForm(Query query) {
            this.newQuery.setQueryConstructType();
            this.newQuery.setConstructTemplate(query.getConstructTemplate());
        }

        public void visitDescribeResultForm(Query query) {
            this.newQuery.setQueryDescribeType();
            for (Node x : query.getResultURIs()) {
                this.newQuery.addDescribeNode(x);
            }
        }

        public void visitAskResultForm(Query query) {
            this.newQuery.setQueryAskType();
        }

        public void visitDatasetDecl(Query query) {
        }

        public void visitQueryPattern(Query query) {
            this.newQuery.setQueryPattern(query.getQueryPattern());
        }

        public void visitGroupBy(Query query) {
            if (query.hasGroupBy()) {
                VarExprList x = query.getGroupBy();
                for (Var v : x.getVars()) {
                    Expr expr = x.getExpr(v);
                    if (expr == null) {
                        this.newQuery.addGroupBy((Node)v);
                        continue;
                    }
                    this.newQuery.addGroupBy(v, expr);
                }
            }
        }

        public void visitHaving(Query query) {
            if (query.hasHaving()) {
                for (Expr expr : query.getHavingExprs()) {
                    this.newQuery.addHavingCondition(expr);
                }
            }
        }

        public void visitOrderBy(Query query) {
            if (query.hasOrderBy()) {
                for (SortCondition sc : query.getOrderBy()) {
                    this.newQuery.addOrderBy(sc);
                }
            }
        }

        public void visitLimit(Query query) {
            this.newQuery.setLimit(query.getLimit());
        }

        public void visitOffset(Query query) {
            this.newQuery.setOffset(query.getOffset());
        }

        public void visitValues(Query query) {
            if (query.hasValues()) {
                this.newQuery.setValuesDataBlock(query.getValuesVariables(), query.getValuesData());
            }
        }

        public void finishVisit(Query query) {
        }

        public void visitJsonResultForm(Query arg0) {
        }
    }
}

