/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.jenax.graphql.sparql.v2.api2.Connective;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaEdge;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNavigator;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNode;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNodeOverObjectTypeDefinition;
import org.aksw.jenax.graphql.util.GraphQlUtils;

public class TransformEnrichWithSchema
extends NodeVisitorStub {
    protected SchemaNavigator schemaNavigator;

    public TransformEnrichWithSchema(SchemaNavigator schemaNavigator) {
        this.schemaNavigator = Objects.requireNonNull(schemaNavigator);
    }

    public TraversalControl enterQuery(OperationDefinition node, TraverserContext<Node> context) {
        if (!context.isVisited()) {
            SchemaNode schemaNode = this.schemaNavigator.getOrCreateSchemaNode("Query");
            context.setVar(SchemaNode.class, (Object)schemaNode);
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl leaveQuery(OperationDefinition node, TraverserContext<Node> context) {
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitOperationDefinition(OperationDefinition node, TraverserContext<Node> context) {
        TraversalControl result = "QUERY".equals(node.getOperation().name()) ? (!context.isVisited() ? this.enterQuery(node, context) : this.leaveQuery(node, context)) : super.visitOperationDefinition(node, context);
        return result;
    }

    public TraversalControl visitField(Field field, TraverserContext<Node> context) {
        TraversalControl result = !context.isVisited() ? this.enterField(field, context) : this.leaveField(field, context);
        return result;
    }

    public TraversalControl enterField(Field field, TraverserContext<Node> context) {
        this.processFieldOnEnter(field, field.getName(), field.getArguments(), (DirectivesContainer<?>)field, field.getSelectionSet(), context);
        return TraversalControl.CONTINUE;
    }

    public void processFieldOnEnter(Field node, String nodeName, List<Argument> arguments, DirectivesContainer<?> directives, SelectionSet selectionSet, TraverserContext<Node> context) {
        SchemaEdge schemaEdge;
        SchemaNode thisSchemaNode = (SchemaNode)context.getVarFromParents(SchemaNode.class);
        if (thisSchemaNode != null && (schemaEdge = (SchemaEdge)thisSchemaNode.getEdge(nodeName).orElse(null)) != null) {
            SchemaNode nextSchemaNode = schemaEdge != null ? schemaEdge.getTargetSchemaNode() : null;
            context.setVar(SchemaNode.class, (Object)nextSchemaNode);
            boolean hasPattern = TransformEnrichWithSchema.hasPattern(node);
            if (!hasPattern) {
                ArrayList<Directive> newDirectives = new ArrayList<Directive>(node.getDirectives().size());
                if (schemaEdge.isCardinalityOne()) {
                    newDirectives.add(GraphQlUtils.newDirective((String)"one", (Argument[])new Argument[0]));
                } else {
                    newDirectives.add(GraphQlUtils.newDirective((String)"many", (Argument[])new Argument[0]));
                }
                newDirectives.addAll(schemaEdge.getFieldDefinition().getDirectives());
                if (nextSchemaNode instanceof SchemaNodeOverObjectTypeDefinition) {
                    SchemaNodeOverObjectTypeDefinition snotd = (SchemaNodeOverObjectTypeDefinition)nextSchemaNode;
                    ObjectTypeDefinition otd = snotd.getObjectTypeDefinition();
                    newDirectives.addAll(otd.getDirectives());
                }
                newDirectives.addAll(node.getDirectives());
                Connective connective = schemaEdge.getConnective();
                GraphQlUtils.replaceDirectives((Node)node, context, GraphQlUtils::directivesSetterField, newDirectives);
            }
        }
    }

    public TraversalControl leaveField(Field field, TraverserContext<Node> context) {
        return TraversalControl.CONTINUE;
    }

    public static boolean hasPattern(DirectivesContainer<?> dirs) {
        boolean result = dirs.hasDirective("rdf") || dirs.hasDirective("pattern") || dirs.hasDirective("iri") || dirs.hasDirective("bind") || dirs.hasDirective("from") || dirs.hasDirective("to");
        return result;
    }
}

