/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jenax.graphql.sparql.v2.api2.Connective;
import org.aksw.jenax.graphql.sparql.v2.api2.ConnectiveVisitor;
import org.aksw.jenax.graphql.sparql.v2.api2.ConnectiveVisitorToString;
import org.aksw.jenax.graphql.sparql.v2.api2.ElementTransform;
import org.aksw.jenax.graphql.sparql.v2.api2.HasParentVarBuilder;
import org.aksw.jenax.graphql.sparql.v2.api2.HasTargetVarBuilder;
import org.aksw.jenax.graphql.sparql.v2.api2.Selection;
import org.aksw.jenax.graphql.sparql.v2.api2.SparqlPathTraversable;
import org.aksw.jenax.graphql.sparql.v2.util.StringUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.Path;

public class ElementNode
implements Selection,
SparqlPathTraversable<ElementNode> {
    protected ParentLink parentLink;
    protected Map<String, JoinLink> nameToChildLink;
    protected String label;
    protected Connective connective;
    protected Long offset;
    protected Long limit;
    protected String identifier;
    protected List<ElementTransform> localTransforms = new ArrayList<ElementTransform>();
    protected List<ElementTransform> treeTransforms = new ArrayList<ElementTransform>();
    protected VarExprList binds = new VarExprList();
    protected List<Var> localTargetVars;

    protected ElementNode(String label, Connective connective) {
        this.label = label;
        this.connective = Objects.requireNonNull(connective);
        this.nameToChildLink = new LinkedHashMap<String, JoinLink>();
    }

    public List<Var> getLocalTargetVars() {
        return this.localTargetVars;
    }

    public ElementNode setLocalTargetVars(List<Var> localTargetVars) {
        if (this.nameToChildLink.size() > 0) {
            throw new IllegalStateException("Cannot set/update target variables once children have been added.");
        }
        this.localTargetVars = localTargetVars;
        return this;
    }

    public List<Var> getEffectiveTargetVars() {
        List<Var> result = this.localTargetVars != null ? this.localTargetVars : this.connective.getDefaultTargetVars();
        return result;
    }

    public ParentLink getParentLink() {
        return this.parentLink;
    }

    public ElementNode findVarInAncestors(Var var) {
        ElementNode result = this.connective.getVisibleVars().contains(var) || this.binds.getVars().contains(var) ? this : (this.parentLink == null ? null : this.parentLink.parent.findVarInAncestors(var));
        return result;
    }

    @Deprecated
    public List<Selection> getSelections() {
        return this.nameToChildLink.values().stream().map(link -> link.child()).toList();
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRoot() {
        return this.parentLink == null;
    }

    public ElementNode setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getAssignedName() {
        String result = this.parentLink == null ? null : this.parentLink.name();
        return result;
    }

    @Override
    public String getName() {
        String result = this.getAssignedName();
        if (result == null) {
            result = "root";
        }
        return result;
    }

    public Connective getConnective() {
        return this.connective;
    }

    public JoinLink getJoinLink() {
        JoinLink result = null;
        if (this.parentLink != null) {
            Map<String, JoinLink> map = this.parentLink.parent().getChildrenByName();
            String lookupName = this.parentLink.name();
            result = map.get(lookupName);
        }
        return result;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ElementNode setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public VarExprList getBinds() {
        return this.binds;
    }

    @Override
    public <T> T accept(ConnectiveVisitor<T> visitor) {
        T result = visitor.visit(this);
        return result;
    }

    public String toString() {
        String result = ConnectiveVisitorToString.toString(this);
        return result;
    }

    public Map<String, JoinLink> getChildrenByName() {
        return this.nameToChildLink;
    }

    @Override
    public ElementNode step(Path path) {
        P_Path0 p0;
        Node node;
        Objects.requireNonNull(path);
        String baseName = null;
        if (path instanceof P_Path0 && (node = (p0 = (P_Path0)path).getNode()).isURI()) {
            baseName = node.getLocalName();
        }
        Connective connective = Connective.of(path);
        ElementNode result = ElementNode.of(baseName, connective);
        this.addChild(result);
        return result;
    }

    public ElementNode addChild(ElementNode child) {
        return this.addChild(this.connective.getDefaultTargetVars(), child, child.getConnective().getConnectVars());
    }

    public ChildAdder prepareChild() {
        return new ChildAdder(this);
    }

    public ElementNode addChild(List<Var> thisVars, ElementNode child) {
        return this.addChild(thisVars, child, child.getConnective().getConnectVars());
    }

    public ElementNode setLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    public Long getLimit() {
        return this.limit;
    }

    public ElementNode setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    public Long getOffset() {
        return this.offset;
    }

    public ElementNode addChild(List<Var> thisVars, ElementNode child, List<Var> childVars) {
        Objects.requireNonNull(child);
        List<Var> finalThisVars = thisVars;
        List<Var> finalChildVars = childVars;
        if (child == this) {
            throw new IllegalArgumentException("Attempt to add a node to itself");
        }
        if (finalChildVars == null) {
            finalChildVars = child.getConnective().getConnectVars();
        }
        if (finalThisVars == null) {
            List<Object> list = finalThisVars = finalChildVars != null && finalChildVars.isEmpty() ? List.of() : this.getEffectiveTargetVars();
        }
        if (finalThisVars.size() != finalChildVars.size()) {
            throw new RuntimeException(String.format("Join var lists differ in size: thisVars=%s, childVars=%s", finalThisVars, finalChildVars));
        }
        Set absentParentVars = finalThisVars.stream().filter(x -> this.findVarInAncestors((Var)x) == null).collect(Collectors.toSet());
        if (!absentParentVars.isEmpty()) {
            throw new RuntimeException("Join variables do not exist on parent:" + String.valueOf(finalThisVars));
        }
        Set absentChildVars = finalChildVars.stream().filter(x -> !child.getConnective().getVisibleVars().contains(x)).collect(Collectors.toSet());
        if (!absentChildVars.isEmpty()) {
            throw new RuntimeException("Join variables do not exist on child:" + String.valueOf(finalThisVars));
        }
        String finalName = ElementNode.adaptName(this, child.getLabel());
        this.addChildInternal(finalName, finalThisVars, child, finalChildVars);
        return this;
    }

    protected void addChildInternal(String finalName, List<Var> thisVars, ElementNode child, List<Var> childVars) {
        JoinLink link = new JoinLink(child, thisVars, childVars);
        if (this.getChildrenByName().containsKey(finalName)) {
            throw new IllegalStateException();
        }
        this.getChildrenByName().put(finalName, link);
        child.setParent(new ParentLink(this, finalName));
    }

    void unlinkFromParent() {
        if (this.parentLink != null) {
            this.parentLink.parent().removeChildByName(this.parentLink.name());
            this.parentLink = null;
        }
    }

    void removeChildByName(String name) {
        this.nameToChildLink.remove(name);
    }

    void setParent(ParentLink parentLink) {
        this.unlinkFromParent();
        this.parentLink = parentLink;
    }

    public List<ElementTransform> getLocalTransforms() {
        return this.localTransforms;
    }

    public List<ElementTransform> getTreeTransforms() {
        return this.treeTransforms;
    }

    public ElementNode addLocalTransform(ElementTransform elementTransform) {
        this.localTransforms.add(elementTransform);
        return this;
    }

    public ElementNode addTreeTransform(ElementTransform elementTransform) {
        this.treeTransforms.add(elementTransform);
        return this;
    }

    public static String adaptName(ElementNode parent, String label) {
        Set<String> childNames = parent.getChildrenByName().keySet();
        String finalBaseName = label == null ? "field" + (childNames.size() + 1) : label;
        String finalName = StringUtils.allocateName(finalBaseName, false, childNames::contains);
        return finalName;
    }

    public static ElementNode of(Connective connective) {
        return ElementNode.of(null, connective);
    }

    public static ElementNode of(String label, Connective connective) {
        return new ElementNode(label, connective);
    }

    public ElementNode clone() {
        ElementNode result = new ElementNode(this.label, this.connective);
        result.offset = this.offset;
        result.limit = this.limit;
        result.identifier = this.identifier;
        result.localTransforms = new ArrayList<ElementTransform>(this.localTransforms);
        result.treeTransforms = new ArrayList<ElementTransform>(this.treeTransforms);
        for (Map.Entry<String, JoinLink> childEntry : this.nameToChildLink.entrySet()) {
            JoinLink joinLink = childEntry.getValue();
            ElementNode newChild = childEntry.getValue().child.clone();
            this.addChildInternal(childEntry.getKey(), joinLink.childVars(), newChild, joinLink.parentVars());
        }
        return result;
    }

    public record ParentLink(ElementNode parent, String name) {
        @Override
        public final String toString() {
            return "ParentLink[" + this.name + "]";
        }
    }

    public record JoinLink(ElementNode child, List<Var> parentVars, List<Var> childVars) {
        public JoinLink {
            if (parentVars.size() != childVars.size()) {
                throw new IllegalArgumentException("Variable lists must have equal size. Got: " + String.valueOf(parentVars) + ", " + String.valueOf(childVars));
            }
        }

        public int size() {
            return this.parentVars.size();
        }

        @Override
        public final String toString() {
            return "JoinLink[parent: " + String.valueOf(this.parentVars) + ", childVars: " + String.valueOf(this.childVars) + "]";
        }
    }

    public static class ChildAdder
    implements HasParentVarBuilder<ChildAdder>,
    HasTargetVarBuilder<ChildAdder> {
        protected ElementNode parentNode;
        protected ElementNode childNode;
        protected List<Var> parentVars;
        protected List<Var> childVars;

        public ChildAdder(ElementNode parentNode) {
            this.parentNode = parentNode;
        }

        public ChildAdder child(ElementNode childNode) {
            this.childNode = childNode;
            return this;
        }

        @Override
        public void setParentVars(List<Var> vars) {
            this.parentVars = vars;
        }

        @Override
        public void setTargetVars(List<Var> vars) {
            this.childVars = vars;
        }

        public ElementNode attach() {
            this.parentNode.addChild(this.parentVars, this.childNode, this.childVars);
            return this.childNode;
        }
    }
}

