/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.io;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.function.Function;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonProviderApi;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonProviderRon;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriterInMemory;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriterInMemoryWrapper;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriterMapperImpl;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriterViaGon;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElement;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfLiteral;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfLiteralImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.util.NodeUtils;

public class GraphQlIoBridge {
    public static String DATATYPE_IRI_JSON = "https://w3id.org/aksw/norse#json";

    public static <T, V> ObjectNotationWriterInMemory<T, P_Path0, Node> bridgeRonToJsonInMemory(GonProviderApi<T, String, V> jsonProvider) {
        ObjectNotationWriterMapperImpl writer;
        ObjectNotationWriterViaGon<T, String, V> destination = ObjectNotationWriterViaGon.of(jsonProvider);
        GonProviderApi gonProvider = jsonProvider;
        Function<P_Path0, String> keyMapper = GraphQlIoBridge::path0ToStrOrNt;
        Function<Node, Object> valueMapper = node -> GraphQlIoBridge.nodeToGon(NodeFactory.createLiteralString((String)NodeFmtLib.strNT((Node)node)), jsonProvider);
        ObjectNotationWriterMapperImpl front = writer = new ObjectNotationWriterMapperImpl(destination, gonProvider, keyMapper, valueMapper);
        ObjectNotationWriterInMemoryWrapper result = new ObjectNotationWriterInMemoryWrapper(front, destination);
        return result;
    }

    public static ObjectNotationWriterInMemory<RdfElement, P_Path0, Node> bridgeRonToRdfElement() {
        ObjectNotationWriterMapperImpl<P_Path0, P_Path0, Node, RdfLiteral> writer;
        GonProviderRon gonProvider = GonProviderRon.getInstance();
        ObjectNotationWriterViaGon<RdfElement, P_Path0, RdfLiteral> destination = ObjectNotationWriterViaGon.of(gonProvider);
        Function<P_Path0, P_Path0> keyMapper = x -> x;
        Function<Node, RdfLiteral> valueMapper = RdfLiteralImpl::new;
        ObjectNotationWriterMapperImpl<P_Path0, P_Path0, Node, RdfLiteral> front = writer = new ObjectNotationWriterMapperImpl<P_Path0, P_Path0, Node, RdfLiteral>(destination, gonProvider, keyMapper, valueMapper);
        ObjectNotationWriterInMemoryWrapper<RdfElement, P_Path0, Node> result = new ObjectNotationWriterInMemoryWrapper<RdfElement, P_Path0, Node>(front, destination);
        return result;
    }

    public static <T, V> ObjectNotationWriterInMemory<T, String, Node> bridgeToJsonInMemory(GonProviderApi<T, String, V> jsonProvider) {
        ObjectNotationWriterMapperImpl writer;
        ObjectNotationWriterViaGon<T, String, V> destination = ObjectNotationWriterViaGon.of(jsonProvider);
        GonProviderApi gonProvider = jsonProvider;
        Function<String, String> keyMapper = x -> x;
        Function<Node, Object> valueMapper = node -> GraphQlIoBridge.nodeToGon(node, jsonProvider);
        ObjectNotationWriterMapperImpl front = writer = new ObjectNotationWriterMapperImpl(destination, gonProvider, keyMapper, valueMapper);
        ObjectNotationWriterInMemoryWrapper result = new ObjectNotationWriterInMemoryWrapper(front, destination);
        return result;
    }

    public static <T, V> T nodeToGon(Node node, GonProviderApi<T, ?, V> gonProvider) {
        Object result;
        if (node == null) {
            result = gonProvider.newNull();
        } else if (node.isURI()) {
            result = gonProvider.newLiteral(node.getURI());
        } else if (node.isLiteral()) {
            Object obj = node.getLiteralValue();
            if (DATATYPE_IRI_JSON.equals(node.getLiteralDatatypeURI())) {
                String lex = node.getLiteralLexicalForm();
                Gson gson = new Gson();
                try {
                    result = gonProvider.parse(lex);
                }
                catch (Exception e) {
                    result = gonProvider.newLiteral(lex);
                }
            } else if (obj instanceof String) {
                String value = (String)obj;
                result = gonProvider.newLiteral(value);
            } else if (obj instanceof Number) {
                Number value = (Number)obj;
                result = gonProvider.newLiteral(value);
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                result = gonProvider.newLiteral(value);
            } else {
                String value = node.getLiteralLexicalForm();
                result = gonProvider.newLiteral(value);
            }
        } else if (node.isBlank()) {
            String value = node.getBlankNodeLabel();
            result = gonProvider.newLiteral(value);
        } else {
            String value = node.toString();
            result = gonProvider.newLiteral(value);
        }
        return result;
    }

    public static JsonElement nodeToJsonElement(Node node) {
        JsonNull result;
        if (node == null) {
            result = JsonNull.INSTANCE;
        } else if (node.isURI()) {
            result = new JsonPrimitive(node.getURI());
        } else if (node.isLiteral()) {
            Object obj = node.getLiteralValue();
            if ("https://w3id.org/aksw/norse#json".equals(node.getLiteralDatatypeURI())) {
                String lex = node.getLiteralLexicalForm();
                Gson gson = new Gson();
                try {
                    result = (JsonElement)gson.fromJson(lex, JsonElement.class);
                }
                catch (Exception e) {
                    result = new JsonPrimitive(lex);
                }
            } else if (obj instanceof String) {
                String value = (String)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Number) {
                Number value = (Number)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                result = new JsonPrimitive(value);
            } else {
                String value = node.getLiteralLexicalForm();
                result = new JsonPrimitive(value);
            }
        } else if (node.isBlank()) {
            String value = node.getBlankNodeLabel();
            result = new JsonPrimitive(value);
        } else {
            String value = node.toString();
            result = new JsonPrimitive(value);
        }
        return result;
    }

    public static String path0ToStrNt(P_Path0 path) {
        boolean isFwd = path.isForward();
        Node node = path.getNode();
        String name = (!isFwd ? "^" : "") + NodeFmtLib.strNT((Node)node);
        return name;
    }

    public static String path0ToStrOrNt(P_Path0 path) {
        boolean isFwd = path.isForward();
        Node node = path.getNode();
        boolean isString = NodeUtils.isSimpleString((Node)node) || NodeUtils.isLangString((Node)node);
        String name = (!isFwd ? "^" : "") + (isString ? node.getLiteralLexicalForm() : NodeFmtLib.strNT((Node)node));
        return name;
    }

    public static String path0ToName(P_Path0 path) {
        boolean isFwd = path.isForward();
        Node node = path.getNode();
        String name = (!isFwd ? "^" : "") + GraphQlIoBridge.getPlainString(node);
        return name;
    }

    public static String getPlainString(Node node) {
        return node == null ? "(null)" : (node.isURI() ? node.getURI() : (node.isBlank() ? node.getBlankNodeLabel() : (node.isLiteral() ? node.getLiteralLexicalForm() : node.toString())));
    }
}

