/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.exec.api.high;

import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.NodeVisitorStub;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExec;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlFieldExec;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlProcessor;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlProcessorSettings;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.RdfGraphQlProcessorBuilder;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.RdfGraphQlProcessorFactoryImpl;
import org.aksw.jenax.graphql.sparql.v2.rewrite.TransformEnrichWithSchema;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNavigator;
import org.aksw.jenax.graphql.util.GraphQlUtils;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.path.P_Path0;

public class GraphQlExecBuilder
implements GraphQlProcessorSettings<GraphQlExecBuilder> {
    protected Creator<QueryExecBuilder> queryExecBuilderFactory;
    protected Document document;
    protected Map<String, Node> assignments = new LinkedHashMap<String, Node>();
    protected SchemaNavigator schemaNavigator = null;
    protected Map<String, FragmentDefinition> nameToFragment = new LinkedHashMap<String, FragmentDefinition>();

    public GraphQlExecBuilder queryExecBuilderFactory(Creator<QueryExecBuilder> queryExecBuilderFactory) {
        this.queryExecBuilderFactory = queryExecBuilderFactory;
        return this;
    }

    @Override
    public GraphQlExecBuilder document(Document document) {
        this.document = document;
        return this;
    }

    @Override
    public GraphQlExecBuilder setVar(String name, Node value) {
        this.assignments.put(name, value);
        return this;
    }

    @Override
    public GraphQlExecBuilder schemaNavigator(SchemaNavigator schemaNavigator) {
        this.schemaNavigator = schemaNavigator;
        return this;
    }

    @Override
    public GraphQlExecBuilder nameToFragment(Map<String, FragmentDefinition> nameToFragment) {
        this.nameToFragment = nameToFragment;
        return this;
    }

    protected Document getEffectiveDocument() {
        Document effectiveQueryDoc = this.schemaNavigator == null ? this.document : GraphQlUtils.applyTransform((Document)this.document, (NodeVisitorStub)new TransformEnrichWithSchema(this.schemaNavigator));
        return effectiveQueryDoc;
    }

    public GraphQlExec<String> buildForJson() {
        Document effectiveQueryDoc = this.getEffectiveDocument();
        GraphQlProcessor processor = ((RdfGraphQlProcessorBuilder)((RdfGraphQlProcessorBuilder)((RdfGraphQlProcessorBuilder)RdfGraphQlProcessorFactoryImpl.forJson().newBuilder().document(effectiveQueryDoc)).setVars(this.assignments)).schemaNavigator(this.schemaNavigator)).build();
        GraphQlFieldExec exec = processor.newExecBuilder().service(this.queryExecBuilderFactory).build();
        return new GraphQlExec<String>(exec);
    }

    public GraphQlExec<P_Path0> buildForRon() {
        Document effectiveQueryDoc = this.getEffectiveDocument();
        GraphQlProcessor processor = ((RdfGraphQlProcessorBuilder)((RdfGraphQlProcessorBuilder)((RdfGraphQlProcessorBuilder)RdfGraphQlProcessorFactoryImpl.forRon().newBuilder().document(effectiveQueryDoc)).setVars(this.assignments)).schemaNavigator(this.schemaNavigator)).build();
        GraphQlFieldExec exec = processor.newExecBuilder().service(this.queryExecBuilderFactory).build();
        return new GraphQlExec<P_Path0>(exec);
    }
}

