/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aksw.jenax.graphql.sparql.v2.schema.Generator;
import org.aksw.jenax.graphql.sparql.v2.schema.VarGeneratorBlacklist;
import org.apache.jena.sparql.core.Var;

public class VarUtils {
    public static Map<Var, Var> createDistinctVarMap(Collection<Var> vas, Collection<Var> vbs, boolean excludeSymmetry, Generator<Var> generator) {
        HashSet<Var> forbidden = new HashSet<Var>();
        forbidden.addAll(vas);
        forbidden.addAll(vbs);
        generator = VarGeneratorBlacklist.create(generator, forbidden);
        HashMap<Var, Var> result = new HashMap<Var, Var>();
        for (Var oldVar : vbs) {
            Var newVar = vas.contains(oldVar) ? (Var)generator.next() : oldVar;
            boolean isSame = oldVar.equals((Object)newVar);
            if (excludeSymmetry && isSame) continue;
            result.put(oldVar, newVar);
        }
        return result;
    }

    public static Map<Var, Var> createJoinVarMap(Collection<Var> sourceVars, Collection<Var> targetVars, List<Var> sourceJoinVars, List<Var> targetJoinVars, Generator<Var> generator) {
        if (sourceJoinVars.size() != targetJoinVars.size()) {
            throw new RuntimeException("Cannot join on different number of columns");
        }
        Map<Var, Var> result = VarUtils.createDistinctVarMap(sourceVars, targetVars, true, generator);
        for (int i = 0; i < sourceJoinVars.size(); ++i) {
            Var sourceJoinVar = sourceJoinVars.get(i);
            Var targetJoinVar = targetJoinVars.get(i);
            result.put(targetJoinVar, sourceJoinVar);
        }
        return result;
    }
}

