/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.schema;

import graphql.language.FieldDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import java.util.Map;
import org.aksw.jenax.graphql.sparql.v2.api2.Connective;
import org.aksw.jenax.graphql.sparql.v2.api2.ConnectiveBuilder;
import org.aksw.jenax.graphql.sparql.v2.rewrite.JenaGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.rewrite.XGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.schema.Fragment;
import org.aksw.jenax.graphql.sparql.v2.schema.GraphQlSchemaUtils;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNavigator;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNode;
import org.aksw.jenax.graphql.sparql.v2.schema.VarGeneratorImpl2;
import org.aksw.jenax.graphql.sparql.v2.schema.VarUtils;
import org.aksw.jenax.graphql.sparql.v2.util.ElementUtils;
import org.aksw.jenax.graphql.sparql.v2.util.PrefixMap2;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class SchemaEdge {
    protected SchemaNavigator navigator;
    protected TypeDefinition<?> source;
    protected volatile PrefixMap localPrefixMap;
    protected FieldDefinition fieldDefinition;

    public SchemaEdge(SchemaNavigator navigator, TypeDefinition<?> source, FieldDefinition fieldDefinition) {
        this.navigator = navigator;
        this.source = source;
        this.fieldDefinition = fieldDefinition;
    }

    public String getName() {
        return this.fieldDefinition.getName();
    }

    public FieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public boolean isCardinalityOne() {
        Type targetType = this.fieldDefinition.getType();
        GraphQlSchemaUtils.TypeInfo typeInfo = GraphQlSchemaUtils.extractTypeInfo(targetType);
        return !typeInfo.isList();
    }

    public SchemaNode getTargetSchemaNode() {
        Type type = this.fieldDefinition.getType();
        GraphQlSchemaUtils.TypeInfo typeInfo = GraphQlSchemaUtils.extractTypeInfo(type);
        String typeName = typeInfo.getTypeName();
        SchemaNode result = this.navigator.getOrCreateSchemaNode(typeName);
        return result;
    }

    public Connective getConnective() {
        GraphQlSchemaUtils.TypeInfo typeInfo;
        SchemaNode targetNode;
        Fragment fragment;
        PrefixMap localPrefixMap = PrefixMapFactory.create();
        JenaGraphQlUtils.collectPrefixes(this.source, localPrefixMap);
        PrefixMap finalPrefixMap = PrefixMap2.of(this.navigator.getBasePrefixMap(), localPrefixMap);
        Connective connective = XGraphQlUtils.parsePattern(this.fieldDefinition, finalPrefixMap);
        Type targetType = this.fieldDefinition.getType();
        if (this.fieldDefinition.hasDirective("filter") && (fragment = (targetNode = this.navigator.getOrCreateSchemaNode((typeInfo = GraphQlSchemaUtils.extractTypeInfo(targetType)).getTypeName())).getFragment()) != null) {
            Element fragmentElt = fragment.element();
            VarGeneratorImpl2 vargen = VarGeneratorImpl2.create();
            Map<Var, Var> varMap = VarUtils.createJoinVarMap(PatternVars.vars((Element)connective.getElement()), PatternVars.vars((Element)fragmentElt), connective.getDefaultTargetVars(), fragment.vars(), vargen);
            Element tmpElt = ElementUtils.applyNodeTransform(fragmentElt, (NodeTransform)new NodeTransformSubst(varMap));
            ElementGroup grp = new ElementGroup();
            ElementUtils.copyElements(grp, connective.getElement());
            ElementUtils.copyElements(grp, tmpElt);
            Element newElt = ElementUtils.groupIfNeeded(grp.getElements());
            connective = ((ConnectiveBuilder)((ConnectiveBuilder)((ConnectiveBuilder)Connective.newBuilder().connectVars(connective.getConnectVars())).targetVars(connective.getDefaultTargetVars())).element(newElt)).build();
        }
        return connective;
    }
}

