/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.ron;

import java.util.Map;
import org.aksw.jenax.graphql.sparql.v2.ron.GraphOverRdfObject;
import org.aksw.jenax.graphql.sparql.v2.ron.Node_RdfObject;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElement;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElementNodeBase;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElementResource;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfLiteralImpl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;

public interface RdfObject
extends RdfElementResource {
    public Map<P_Path0, RdfElement> getMembers();

    public RdfObject addForward(Node var1, RdfElement var2);

    public RdfObject addForward(RDFNode var1, RdfElement var2);

    public RdfObject addBackward(Node var1, RdfElement var2);

    public RdfObject addBackward(RDFNode var1, RdfElement var2);

    default public RdfObject addForward(String key, String value) {
        Node k = NodeFactory.createLiteralString((String)key);
        RdfLiteralImpl v = new RdfLiteralImpl(NodeFactory.createLiteralString((String)value));
        this.addForward(k, (RdfElement)v);
        return this;
    }

    default public RdfObject add(Node key, boolean isForward, RdfElement value) {
        P_Link p = isForward ? new P_Link(key) : new P_ReverseLink(key);
        this.add((P_Path0)p, value);
        return this;
    }

    default public RdfObject addStr(String name, RdfElement value) {
        this.add((P_Path0)new P_Link(NodeFactory.createLiteralString((String)name)), value);
        return this;
    }

    default public RdfObject add(P_Path0 key, RdfElement value) {
        this.getMembers().put(key, value);
        return this;
    }

    default public RdfElement get(String name) {
        return this.get(NodeFactory.createLiteralString((String)name));
    }

    default public RdfObject getObject(String name) {
        RdfElement elt = this.get(name);
        RdfObject result = elt == null ? null : elt.getAsObject();
        return result;
    }

    default public RdfElement getIri(String iriStr) {
        return this.get(NodeFactory.createURI((String)iriStr));
    }

    default public RdfElement get(Node node) {
        return this.getMembers().get(new P_Link(node));
    }

    default public RdfElement get(RDFNode rdfNode) {
        return this.get(rdfNode.asNode());
    }

    default public RdfElement get(P_Path0 key) {
        return this.getMembers().get(key);
    }

    default public RdfObject remove(P_Path0 key) {
        Map<P_Path0, RdfElement> map = this.getMembers();
        RdfElement elt = map.get(key);
        if (elt != null) {
            ((RdfElementNodeBase)elt).setParent(null);
            map.remove(key);
        }
        return this;
    }

    default public <T extends RDFNode> T as(Class<T> cls) {
        Node node = Node_RdfObject.of(this);
        GraphOverRdfObject g = new GraphOverRdfObject();
        Model model = ModelFactory.createModelForGraph((Graph)g);
        RDFNode rdfNode = model.asRDFNode(node);
        RDFNode result = rdfNode.as(cls);
        return (T)result;
    }
}

