/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.FieldDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import org.aksw.jenax.graphql.sparql.v2.model.XGraphQlConstants;
import org.aksw.jenax.graphql.sparql.v2.rewrite.JenaGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.rewrite.TransformDirectivesBase;
import org.aksw.jenax.graphql.sparql.v2.schema.GraphQlSchemaUtils;
import org.aksw.jenax.graphql.util.GraphQlUtils;

public class TransformHarmonizeTentris
extends TransformDirectivesBase {
    @Override
    protected <T extends Node<T>> TraversalControl process(String nodeName, T node, DirectivesContainer<?> directives, TraverserContext<Node> context, BiFunction<T, List<Directive>, T> transform) {
        boolean hasUri;
        boolean change = false;
        boolean hasInverse = directives.hasDirective("inverse");
        LinkedList<Directive> remainingDirectives = new LinkedList<Directive>(directives.getDirectives());
        if (hasInverse) {
            remainingDirectives.removeIf(x -> "inverse".equals(x.getName()));
            remainingDirectives.add(Directive.newDirective().name("reverse").build());
            change = true;
        }
        if (hasUri = directives.hasDirective("uri")) {
            String iriStr = JenaGraphQlUtils.parseRdfIri(nodeName, directives, "uri", "value", null, null);
            GraphQlUtils.removeDirectivesByName(remainingDirectives, (String)"uri");
            boolean isClass = node instanceof ObjectTypeDefinition;
            if (isClass) {
                remainingDirectives.addFirst(GraphQlUtils.newDirective((String)XGraphQlConstants.type, (Argument[])new Argument[]{GraphQlUtils.newArgString((String)"iri", (String)iriStr)}));
            } else {
                remainingDirectives.addFirst(GraphQlUtils.newDirective((String)"rdf", (Argument[])new Argument[]{GraphQlUtils.newArgString((String)"iri", (String)iriStr)}));
            }
            change = true;
        }
        if (change) {
            GraphQlUtils.replaceDirectivesOld(node, context, transform, remainingDirectives);
        }
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitFieldDefinitionActual(FieldDefinition node, TraverserContext<Node> context) {
        boolean isIdField = TransformHarmonizeTentris.isIdField(node);
        if (isIdField) {
            LinkedList<Directive> remainingDirectives = new LinkedList<Directive>(node.getDirectives());
            remainingDirectives.addFirst(GraphQlUtils.newDirective((String)"to", (Argument[])new Argument[0]));
            node = (FieldDefinition)GraphQlUtils.replaceDirectives((Node)node, context, GraphQlUtils::directivesSetterFieldDefinition, remainingDirectives);
        }
        return super.visitFieldDefinitionActual(node, context);
    }

    public static boolean isIdField(FieldDefinition node) {
        GraphQlSchemaUtils.TypeInfo typeInfo = GraphQlSchemaUtils.extractTypeInfo(node.getType());
        boolean result = TransformHarmonizeTentris.isIdField(typeInfo);
        return result;
    }

    public static boolean isIdField(GraphQlSchemaUtils.TypeInfo typeInfo) {
        boolean result = typeInfo.getTypeName().equals("ID");
        return result;
    }
}

