/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Node;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import java.util.List;
import org.aksw.jenax.graphql.util.GraphQlUtils;
import org.apache.jena.riot.system.PrefixMap;

public class JenaGraphQlUtils {
    public static PrefixMap collectPrefixes(Directive node, PrefixMap prefixMap) {
        Value map;
        String prefix = GraphQlUtils.getArgAsString((Directive)node, (String)"name");
        String iri = GraphQlUtils.getArgAsString((Directive)node, (String)"iri");
        if (prefix != null && iri != null) {
            prefixMap.add(prefix, iri);
        }
        if ((map = GraphQlUtils.getArgValue((Directive)node, (String)"map")) != null) {
            JenaGraphQlUtils.readPrefixMap(prefixMap, map);
        }
        return prefixMap;
    }

    public static PrefixMap collectPrefixes(DirectivesContainer<?> directivesContainer, PrefixMap prefixMap) {
        List matches = directivesContainer.getDirectives("prefix");
        matches.forEach(directive -> JenaGraphQlUtils.collectPrefixes(directive, prefixMap));
        return prefixMap;
    }

    public static ObjectValue toObjectValue(PrefixMap prefixes) {
        List<ObjectField> fields = prefixes.getMapping().entrySet().stream().map(e -> ObjectField.newObjectField().name((String)e.getKey()).value((Value)StringValue.of((String)((String)e.getValue()))).build()).toList();
        ObjectValue result = ObjectValue.newObjectValue().objectFields(fields).build();
        return result;
    }

    public static PrefixMap readPrefixMap(PrefixMap result, Value<?> value) {
        if (value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)value;
            for (ObjectField field : obj.getObjectFields()) {
                String prefix = field.getName();
                String namespace = GraphQlUtils.toString((Node)field.getValue());
                result.add(prefix, namespace);
            }
        }
        return result;
    }

    public static boolean readPrefixDirective(Directive node, PrefixMap outPrefixes) {
        String name;
        boolean result = false;
        switch (name = node.getName()) {
            case "prefix": {
                Value map;
                String prefix = GraphQlUtils.getArgAsString((Directive)node, (String)"name");
                String iri = GraphQlUtils.getArgAsString((Directive)node, (String)"iri");
                if (prefix != null && iri != null) {
                    outPrefixes.add(prefix, iri);
                }
                if ((map = GraphQlUtils.getArgValue((Directive)node, (String)"map")) != null) {
                    JenaGraphQlUtils.readPrefixMap(outPrefixes, map);
                }
                result = true;
                break;
            }
        }
        return result;
    }

    public static String resolveIri(String iriStr, PrefixMap prefixMap) {
        String result = null;
        if (iriStr != null && prefixMap != null && (result = prefixMap.get(iriStr)) == null) {
            result = prefixMap.expand(iriStr);
        }
        if (result == null) {
            result = iriStr;
        }
        return result;
    }

    public static String getArgAsIriString(Directive directive, String argName, PrefixMap prefixMap) {
        String iriStr = GraphQlUtils.getArgAsString((Directive)directive, (String)argName);
        String result = JenaGraphQlUtils.resolveIri(iriStr, prefixMap);
        return result;
    }

    public static String parseRdfIri(String nodeName, DirectivesContainer<?> directives, String directiveName, String iriArgName, String nsArgName, PrefixMap prefixMap) {
        Directive directive = GraphQlUtils.expectAtMostOneDirective(directives, (String)directiveName);
        String result = directive == null ? null : JenaGraphQlUtils.parseRdfIri(nodeName, directive, iriArgName, nsArgName, prefixMap);
        return result;
    }

    public static String parseRdfIri(String nodeName, Directive directive, String iriArgName, String nsArgName, PrefixMap prefixMap) {
        String finalNs;
        String finalIri = JenaGraphQlUtils.getArgAsIriString(directive, iriArgName, prefixMap);
        String string = finalNs = nsArgName == null ? null : JenaGraphQlUtils.getArgAsIriString(directive, nsArgName, prefixMap);
        if (finalIri != null && finalNs != null) {
            System.err.println("Warn: iri and ns are mutually exclusive");
        }
        String finalFieldName = nodeName;
        String result = finalIri != null ? finalIri : finalNs + finalFieldName;
        return result;
    }
}

