/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;

public class Bind {
    public static BindingMapperVar var(String varName) {
        return Bind.var(Var.alloc((String)varName));
    }

    public static BindingMapperVar var(Var var) {
        return new BindingMapperVar(var);
    }

    public static BindingMapperVars vars(String ... varNames) {
        List list = Var.varList(Arrays.asList(varNames));
        return Bind.vars(list);
    }

    public static BindingMapperVars vars(List<Var> vars) {
        return new BindingMapperVars(vars);
    }

    public static BindingMapperExpr expr(Expr expr) {
        return new BindingMapperExpr(expr);
    }

    public static BindingMapperExpr TRUE() {
        return new BindingMapperExpr((Expr)NodeValue.TRUE);
    }

    public static BindingMapperExpr FALSE() {
        return new BindingMapperExpr((Expr)NodeValue.FALSE);
    }

    public static class BindingMapperVar
    implements BindingMapper<Node> {
        protected Var var;

        public BindingMapperVar(Var var) {
            this.var = var;
        }

        @Override
        public Node apply(Binding t, FunctionEnv u) {
            return t.get(this.var);
        }

        public String toString() {
            return "Binder(" + String.valueOf(this.var) + ")";
        }
    }

    public static class BindingMapperVars
    implements BindingMapper<Node> {
        protected List<Var> vars;

        public BindingMapperVars(List<Var> vars) {
            this.vars = vars;
        }

        @Override
        public Node apply(Binding t, FunctionEnv u) {
            List<Node> nodes = this.vars.stream().map(arg_0 -> ((Binding)t).get(arg_0)).toList();
            String str = nodes.stream().map(n -> n == null ? "UNDEF" : BindingMapperVars.fmtNode(n)).collect(Collectors.joining(" "));
            return NodeFactory.createLiteralString((String)str);
        }

        public String toString() {
            return "Binder(" + String.valueOf(this.vars) + ")";
        }

        public static String fmtNode(Node node) {
            return node.isLiteral() && node.getLiteralValue() instanceof Number ? NodeFmtLib.strTTL((Node)node) : NodeFmtLib.strNT((Node)node);
        }
    }

    public static class BindingMapperExpr
    implements BindingMapper<Node> {
        protected Expr expr;

        public BindingMapperExpr(Expr expr) {
            this.expr = expr;
        }

        @Override
        public Node apply(Binding t, FunctionEnv u) {
            NodeValue nv = this.expr.eval(t, u);
            Node result = nv == null ? null : nv.asNode();
            return result;
        }

        public String toString() {
            return "Binder(" + String.valueOf(this.expr) + ")";
        }
    }

    static interface BindingMapper<T>
    extends BiFunction<Binding, FunctionEnv, T> {
    }
}

