/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateBase;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateGon;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateTypeProduceEntry;

public class AccStateMap<I, E, K, V>
extends AccStateBase<I, E, K, V>
implements AccStateTypeProduceEntry<I, E, K, V> {
    protected BiFunction<I, E, ? extends K> inputToKeyMapper;
    protected BiPredicate<I, E> testIfSingle;
    protected AccStateGon<I, E, K, V> subAcc;
    protected Object currentKey;
    protected boolean isCurrentKeySingle;
    protected int seenTargetCount = 0;
    protected boolean skipOutputStartedHere = false;
    protected Object matchStateId;

    public AccStateMap(Object matchStateId, BiFunction<I, E, ? extends K> inputToKeyMapper, BiPredicate<I, E> testIfSingle, AccStateGon<I, E, K, V> subAcc) {
        this.matchStateId = matchStateId;
        this.inputToKeyMapper = Objects.requireNonNull(inputToKeyMapper);
        this.testIfSingle = testIfSingle;
        this.subAcc = subAcc;
    }

    @Override
    public AccStateGon<I, E, K, V> transitionActual(Object inputStateId, I input, E env) throws IOException {
        AccStateGon<I, E, K, V> result;
        if (!Objects.equals(inputStateId, this.matchStateId)) {
            result = null;
        } else {
            K key = this.inputToKeyMapper.apply(input, env);
            if (!Objects.equals(key, this.currentKey)) {
                this.endOpenArray();
                this.seenTargetCount = 0;
                this.skipOutputStartedHere = false;
                this.currentKey = key;
                if (!this.skipOutput && this.context.isSerialize()) {
                    this.context.getJsonWriter().name(key);
                }
                this.isCurrentKeySingle = this.testIfSingle.test(input, env);
                if (!this.isCurrentKeySingle && !this.skipOutput && this.context.isSerialize()) {
                    this.context.getJsonWriter().beginArray();
                }
            }
            this.skipOutputStartedHere = this.isCurrentKeySingle && this.seenTargetCount >= 1;
            this.subAcc.begin(key, input, env, this.skipOutput || this.skipOutputStartedHere);
            ++this.seenTargetCount;
            result = this.subAcc;
        }
        return result;
    }

    protected void endOpenArray() throws IOException {
        if (this.currentKey != null) {
            if (!this.isCurrentKeySingle && !this.skipOutput && this.context.isSerialize()) {
                this.context.getJsonWriter().endArray();
            }
            this.currentKey = null;
        }
    }

    @Override
    public void endActual() throws IOException {
        this.endOpenArray();
    }

    public String toString() {
        return "AccStateMap(matches: " + String.valueOf(this.matchStateId) + ", source: " + String.valueOf(this.currentSourceNode) + ", target: " + String.valueOf(this.subAcc) + ")";
    }

    @Override
    public Iterator<? extends AccStateGon<I, E, K, V>> children() {
        return List.of(this.subAcc).iterator();
    }

    @Override
    public Object getMatchStateId() {
        return this.matchStateId;
    }
}

