/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccJsonErrorHandler;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccState;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateGon;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.AccStatePropertyBase;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.ArrayMode;
import org.aksw.jenax.graphql.sparql.v2.gon.meta.GonType;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonProvider;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriter;

public class AccStateLiteralProperty<I, E, K, V>
extends AccStatePropertyBase<I, E, K, V> {
    protected boolean skipIfNull;
    protected ArrayMode arrayMode;
    protected BiFunction<I, E, ? extends V> inputToValue;
    protected boolean skipOutputStartedHere = false;
    protected long seenTargetCount = 0L;
    protected Object value;

    public AccStateLiteralProperty(Object matchStateId, K memberKey, boolean isSingle, boolean skipIfNull, ArrayMode arrayMode, BiFunction<I, E, ? extends V> inputToValue) {
        super(matchStateId, memberKey, isSingle);
        this.skipIfNull = skipIfNull;
        this.inputToValue = inputToValue;
        this.arrayMode = Objects.requireNonNull(arrayMode);
    }

    @Override
    public GonType getGonType() {
        GonType result = switch (this.arrayMode) {
            case ArrayMode.OFF -> GonType.ENTRY;
            case ArrayMode.FLAT -> GonType.LITERAL;
            case ArrayMode.NESTED -> GonType.ARRAY;
            default -> throw new IllegalStateException("Should not happen");
        };
        return result;
    }

    public static <I, E, K, V> AccStateLiteralProperty<I, E, K, V> of(Object matchStateId, K memberKey, boolean isSingle, boolean skipIfNull, ArrayMode arrayMode, BiFunction<I, E, ? extends V> inputToValue) {
        return new AccStateLiteralProperty<I, E, K, V>(matchStateId, memberKey, isSingle, skipIfNull, arrayMode, inputToValue);
    }

    @Override
    public void beginActual() throws IOException {
        this.seenTargetCount = 0L;
        this.skipOutputStartedHere = false;
        if (!this.skipOutput) {
            if (this.context.isMaterialize()) {
                GonProvider gonProvider = this.context.getGonProvider();
                throw new RuntimeException("TODO update materialization");
            }
            if (this.context.isSerialize()) {
                ObjectNotationWriter writer = this.context.getJsonWriter();
                if (!this.isSingle) {
                    if (ArrayMode.OFF.equals((Object)this.arrayMode)) {
                        writer.name(this.memberKey);
                    }
                    if (!ArrayMode.FLAT.equals((Object)this.arrayMode)) {
                        writer.beginArray();
                    }
                } else if (ArrayMode.NESTED.equals((Object)this.arrayMode)) {
                    writer.beginArray();
                }
            }
        }
    }

    @Override
    public AccStateGon<I, E, K, V> transitionActual(Object inputStateId, I input, E env) throws IOException {
        AccStateLiteralProperty result = null;
        if (Objects.equals(this.matchStateId, inputStateId)) {
            boolean isTooMany;
            ++this.seenTargetCount;
            boolean bl = isTooMany = this.isSingle && this.seenTargetCount > 1L;
            if (isTooMany) {
                this.skipOutputStartedHere = true;
                AccJsonErrorHandler errorHandler = this.context.getErrorHandler();
                if (errorHandler != null) {
                    throw new RuntimeException("Error handler not yet implemented");
                }
            } else {
                V currentValue = this.inputToValue.apply(input, env);
                if (!(currentValue == null && this.skipIfNull || this.skipOutput || !this.context.isSerialize())) {
                    ObjectNotationWriter<Object, V> writer = this.context.getJsonWriter();
                    if (this.isSingle && ArrayMode.OFF.equals((Object)this.arrayMode)) {
                        writer.name(this.memberKey);
                    }
                    writer.value(currentValue);
                }
            }
            result = this;
        }
        return result;
    }

    @Override
    public void endActual() throws IOException {
        if (!this.skipOutput) {
            if (this.context.isMaterialize()) {
                GonProvider gonProvider = this.context.getGonProvider();
                if (this.parent != null) {
                    Object elt = this.value == null ? gonProvider.newNull() : this.value;
                    AccState valueParent = this.getParent();
                    throw new RuntimeException("materialization no longer supported");
                }
            }
            if (this.context.isSerialize()) {
                ObjectNotationWriter writer = this.context.getJsonWriter();
                if (!this.isSingle) {
                    if (!ArrayMode.FLAT.equals((Object)this.arrayMode)) {
                        writer.endArray();
                    }
                } else {
                    if (this.seenTargetCount == 0L && !this.skipIfNull) {
                        if (ArrayMode.OFF.equals((Object)this.arrayMode)) {
                            writer.name(this.memberKey);
                        }
                        writer.nullValue();
                    }
                    if (ArrayMode.NESTED.equals((Object)this.arrayMode)) {
                        writer.endArray();
                    }
                }
            }
        }
    }

    public String toString() {
        return "AccStateLiteralProperty(matches: " + String.valueOf(this.matchStateId) + ", currentInput: " + String.valueOf(this.currentInput) + ")";
    }

    @Override
    public Iterator<? extends AccStateGon<I, E, K, V>> children() {
        return Collections.emptyIterator();
    }
}

