/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.schema;

import graphql.language.Document;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.parser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.aksw.jenax.graphql.sparql.v2.rewrite.TransformHarmonizeTentris;
import org.aksw.jenax.graphql.sparql.v2.util.GraphQlUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.system.stream.StreamManager;

public class GraphQlSchemaUtils {
    public static TypeInfo extractTypeInfo(Type<?> type) {
        boolean isList = false;
        boolean isNonNull = false;
        while (true) {
            if (type instanceof NonNullType) {
                NonNullType nonNullType = (NonNullType)type;
                isNonNull = true;
                type = nonNullType.getType();
                continue;
            }
            if (!(type instanceof ListType)) break;
            ListType listType = (ListType)type;
            isList = true;
            type = listType.getType();
        }
        if (type instanceof TypeName) {
            TypeName typeName = (TypeName)type;
            return new TypeInfo(typeName.getName(), isList, isNonNull);
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(type));
    }

    public static Document loadMetaSchema() {
        try {
            return GraphQlSchemaUtils.loadDocument("jenax.meta.gqls");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document loadDocument(String resource) throws IOException {
        StreamManager streamMgr = StreamManager.get();
        Parser parser = new Parser();
        String metaSchemaRawStr = GraphQlSchemaUtils.toStringUtf8(streamMgr, resource);
        Document metaDoc = parser.parseDocument(metaSchemaRawStr);
        return metaDoc;
    }

    public static Document merge(Document ... documents) {
        ArrayList mergedDefinitions = new ArrayList();
        for (Document doc : documents) {
            mergedDefinitions.addAll(doc.getDefinitions());
        }
        Document mergedDoc = Document.newDocument().definitions(mergedDefinitions).build();
        return mergedDoc;
    }

    public static Document harmonize(Document doc) {
        Document result = GraphQlUtils.applyTransform(doc, new TransformHarmonizeTentris());
        return result;
    }

    public static Document loadSchema(String graphQlSchemaResource) throws IOException {
        Document metaDoc = GraphQlSchemaUtils.loadMetaSchema();
        Document schemaDoc = GraphQlSchemaUtils.loadDocument(graphQlSchemaResource);
        ArrayList mergedDefinitions = new ArrayList();
        mergedDefinitions.addAll(metaDoc.getDefinitions());
        mergedDefinitions.addAll(schemaDoc.getDefinitions());
        Document mergedDoc = GraphQlSchemaUtils.merge(metaDoc, schemaDoc);
        mergedDoc = GraphQlSchemaUtils.harmonize(mergedDoc);
        return mergedDoc;
    }

    public static String toStringUtf8(StreamManager streamMgr, String resourceName) throws IOException {
        String result;
        try (TypedInputStream in = streamMgr.open(resourceName);){
            result = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        return result;
    }

    public static class TypeInfo {
        private final String typeName;
        private final boolean isList;
        private final boolean isNonNull;

        public TypeInfo(String typeName, boolean isList, boolean isNonNull) {
            this.typeName = typeName;
            this.isList = isList;
            this.isNonNull = isNonNull;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isList() {
            return this.isList;
        }

        public boolean isNonNull() {
            return this.isNonNull;
        }

        public String toString() {
            return (this.isNonNull ? "NonNull " : "") + (this.isList ? "List<" : "") + this.typeName + (this.isList ? ">" : "");
        }
    }
}

