/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.ron;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.jenax.graphql.sparql.v2.ron.Node_RdfObject;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfArray;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfArrayImpl;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElement;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfElementNodeBase;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfLiteralImpl;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfObject;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfObjectImpl;
import org.aksw.jenax.graphql.sparql.v2.util.NodeUtils;
import org.aksw.jenax.graphql.sparql.v2.util.TripleUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class GraphOverRdfObject
extends GraphBase {
    public static Stream<Triple> streamTriples(RdfObject obj) {
        return obj.getMembers().entrySet().stream().flatMap(e -> {
            Node s = obj.getExternalId();
            if (s == null) {
                s = obj.getInternalId();
            }
            P_Path0 k = (P_Path0)e.getKey();
            RdfElement elt = (RdfElement)e.getValue();
            return GraphOverRdfObject.streamTriples(s, k.getNode(), elt, k.isForward());
        });
    }

    public static Stream<Triple> streamTriples(Node s, Node p, RdfElement elt, boolean isForward) {
        Stream<Object> result;
        if (elt.isNull()) {
            result = Stream.of(new Triple[0]);
        } else if (elt.isLiteral()) {
            Node o = elt.getAsLiteral().getInternalId();
            Triple t = TripleUtils.create(s, p, o, isForward);
            result = Stream.of(t);
        } else if (elt.isObject()) {
            RdfObject obj = elt.getAsObject();
            Node o = obj.getExternalId();
            if (o == null) {
                o = obj.getInternalId();
            }
            Triple t = TripleUtils.create(s, p, o, isForward);
            result = Stream.concat(Stream.of(t), GraphOverRdfObject.streamTriples(obj));
        } else if (elt.isArray()) {
            result = Iter.asStream(elt.getAsArray().iterator()).flatMap(item -> GraphOverRdfObject.streamTriples(s, p, item, isForward));
        } else {
            throw new RuntimeException("should not come here");
        }
        return result;
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
        Node ms = triplePattern.getMatchSubject();
        Node mp = triplePattern.getMatchPredicate();
        Node mo = triplePattern.getMatchObject();
        Iter<Triple> it = null;
        if (ms instanceof Node_RdfObject) {
            Node_RdfObject so = (Node_RdfObject)ms;
            it = this.match(so, mp, mo, true);
        }
        if (mo instanceof Node_RdfObject) {
            Node_RdfObject oo = (Node_RdfObject)mo;
            Iter it2 = this.match(oo, mp, ms, false);
            it = it == null ? it2 : Iter.concat(it, it2);
        }
        return it == null ? NiceIterator.emptyIterator() : WrappedIterator.create(it);
    }

    public Iter<Triple> match(Node_RdfObject src, Node p, Node o, boolean isForward) {
        Iter itMembers;
        if (NodeUtils.isNullOrAny(p)) {
            itMembers = Iter.iter(((RdfObject)src.get()).getMembers().entrySet()).filter(e -> ((P_Path0)e.getKey()).isForward() == isForward);
        } else {
            P_Link pp = isForward ? new P_Link(p) : new P_ReverseLink(p);
            itMembers = Iter.ofNullable((Object)((RdfObject)src.get()).getMembers().get(pp)).map(arg_0 -> GraphOverRdfObject.lambda$match$3((P_Path0)pp, arg_0));
        }
        return itMembers.flatMap(e -> {
            P_Path0 pp = (P_Path0)e.getKey();
            RdfElement elt = (RdfElement)e.getValue();
            Iter values = elt.isArray() ? Iter.iter(elt.getAsArray().iterator()) : Iter.of((Object)elt);
            Iter filteredValues = NodeUtils.isNullOrAny(o) ? values : values.filter(v -> GraphOverRdfObject.matches(v, o));
            return filteredValues.filter(x -> !x.isNull()).map(x -> TripleUtils.create((Node)src, pp.getNode(), GraphOverRdfObject.wrap(x), isForward));
        });
    }

    public static Node wrap(RdfElement elt) {
        Node result;
        if (elt.isArray()) {
            throw new RuntimeException("should not happen");
        }
        if (elt.isLiteral()) {
            result = elt.getAsLiteral().getInternalId();
        } else if (elt.isObject()) {
            result = Node_RdfObject.of(elt.getAsObject());
        } else if (elt.isNull()) {
            result = null;
        } else {
            throw new RuntimeException("should not happed");
        }
        return result;
    }

    public static boolean matches(RdfElement elt, Node node) {
        Node_RdfObject no;
        if (node instanceof Node_RdfObject && elt == (no = (Node_RdfObject)node).get()) {
            return true;
        }
        if (elt.isObject()) {
            RdfObject obj = elt.getAsObject();
            Node externalId = obj.getExternalId();
            if (externalId != null) {
                return externalId.equals((Object)node);
            }
            Node internalId = obj.getInternalId();
            return internalId.equals((Object)node);
        }
        if (elt.isLiteral()) {
            return elt.getAsLiteral().getInternalId().equals((Object)node);
        }
        return false;
    }

    public static RdfElement arrayToRdfList(RdfArray arr) {
        Iterator it = arr.iterator();
        RdfElementNodeBase root = null;
        RdfObject previous = null;
        while (it.hasNext()) {
            RdfElement item = (RdfElement)it.next();
            if (item.isNull()) continue;
            RdfObjectImpl current = new RdfObjectImpl();
            current.addForward((RDFNode)RDF.first, item);
            if (previous == null) {
                root = current;
            } else {
                previous.addForward((RDFNode)RDF.rest, (RdfElement)current);
            }
            previous = current;
        }
        if (previous != null) {
            previous.addForward((RDFNode)RDF.rest, (RdfElement)new RdfLiteralImpl(RDF.nil));
        }
        RdfLiteralImpl result = root == null ? new RdfLiteralImpl(RDF.nil) : root;
        return result;
    }

    public static void main(String[] args) {
        RdfObjectImpl s1 = new RdfObjectImpl();
        s1.addForward((RDFNode)RDF.type, (RdfElement)new RdfLiteralImpl(OWL.Class));
        s1.addForward((RDFNode)RDFS.label, (RdfElement)new RdfLiteralImpl(NodeFactory.createURI((String)"s1")));
        RdfArrayImpl arr1 = new RdfArrayImpl();
        s1.addBackward((RDFNode)FOAF.knows, (RdfElement)arr1);
        RdfObjectImpl s2 = new RdfObjectImpl();
        s2.addForward((RDFNode)RDF.type, (RdfElement)new RdfLiteralImpl(RDFS.Class));
        s2.addForward((RDFNode)RDFS.label, (RdfElement)new RdfLiteralImpl(NodeFactory.createURI((String)"s2")));
        RdfArrayImpl arr2 = new RdfArrayImpl();
        s1.addForward((RDFNode)RDFS.seeAlso, (RdfElement)s2);
        arr2.add(new RdfLiteralImpl(NodeFactory.createURI((String)"incoming1")));
        arr2.add(new RdfLiteralImpl(NodeFactory.createURI((String)"incoming2")));
        arr2.add(new RdfLiteralImpl(NodeFactory.createURI((String)"incoming3")));
        s2.addForward((RDFNode)FOAF.knows, GraphOverRdfObject.arrayToRdfList(arr2));
        Resource r = s2.as(Resource.class);
        r.listProperties().forEach(stmt -> System.out.println(stmt));
        Model model = r.getModel();
        Model closure = ResourceUtils.reachableClosure((Resource)r);
        RDFDataMgr.write((OutputStream)System.out, (Model)closure, (RDFFormat)RDFFormat.NTRIPLES);
    }

    private static /* synthetic */ Map.Entry lambda$match$3(P_Path0 pp, RdfElement x) {
        return Map.entry(pp, x);
    }
}

