/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.OperationDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TransformDirectiveOnTopLevelFieldToQueryBase
extends NodeVisitorStub {
    protected String targetDirectiveName;

    public TransformDirectiveOnTopLevelFieldToQueryBase(String targetDirectiveName) {
        this.targetDirectiveName = Objects.requireNonNull(targetDirectiveName);
    }

    public TraversalControl visitOperationDefinition(OperationDefinition node, TraverserContext<Node> context) {
        boolean hasFieldWithDirective;
        if (!context.isVisited() && OperationDefinition.Operation.QUERY.equals((Object)node.getOperation()) && !node.hasDirective(this.targetDirectiveName) && (hasFieldWithDirective = node.getSelectionSet().getSelectionsOfType(Field.class).stream().anyMatch(field -> field.hasDirective(this.targetDirectiveName)))) {
            TransformDirectiveOnTopLevelFieldToQueryBase.transform(this.targetDirectiveName, node, context, newDirectives -> {
                OperationDefinition newNode = node.transform(builder -> builder.directives(newDirectives));
                TreeTransformerUtil.changeNode((TraverserContext)context, (Object)newNode);
            });
        }
        return super.visitOperationDefinition(node, context);
    }

    public static <T extends DirectivesContainer<?>> TraversalControl transform(String targetDirectiveName, T node, TraverserContext<Node> context, Consumer<List<Directive>> action) {
        if (!context.isVisited()) {
            LinkedList remainingDirectives = node.getDirectives().stream().filter(directive -> !targetDirectiveName.equals(directive.getName())).collect(Collectors.toCollection(LinkedList::new));
            Directive d = Directive.newDirective().name(targetDirectiveName).build();
            remainingDirectives.addFirst(d);
            action.accept(remainingDirectives);
        }
        return TraversalControl.CONTINUE;
    }
}

