/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.NodeVisitorStub;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilder;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderEdge;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderFragmentBody;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderFragmentHead;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderLiteral;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderLiteralProperty;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderMap;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderObject;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderObjectLikeBase;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderProperty;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderTransitionBase;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.builder.AggStateBuilderTransitionMatch;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.ArrayMode;
import org.aksw.jenax.graphql.sparql.v2.api2.Connective;
import org.aksw.jenax.graphql.sparql.v2.api2.ConnectiveBuilder;
import org.aksw.jenax.graphql.sparql.v2.api2.ElementTransform;
import org.aksw.jenax.graphql.sparql.v2.api2.QueryUtils;
import org.aksw.jenax.graphql.sparql.v2.context.BindDirective;
import org.aksw.jenax.graphql.sparql.v2.context.CardinalityDirective;
import org.aksw.jenax.graphql.sparql.v2.context.ConditionDirective;
import org.aksw.jenax.graphql.sparql.v2.context.FragmentCxt;
import org.aksw.jenax.graphql.sparql.v2.context.FragmentCxtHolder;
import org.aksw.jenax.graphql.sparql.v2.context.GraphDirective;
import org.aksw.jenax.graphql.sparql.v2.context.IndexDirective;
import org.aksw.jenax.graphql.sparql.v2.context.JoinDirective;
import org.aksw.jenax.graphql.sparql.v2.model.ElementNode;
import org.aksw.jenax.graphql.sparql.v2.model.XGraphQlConstants;
import org.aksw.jenax.graphql.sparql.v2.rewrite.Bind;
import org.aksw.jenax.graphql.sparql.v2.rewrite.ElementTransformGraph;
import org.aksw.jenax.graphql.sparql.v2.rewrite.GraphQlFieldRewrite;
import org.aksw.jenax.graphql.sparql.v2.rewrite.JenaGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.rewrite.RewriteResult;
import org.aksw.jenax.graphql.sparql.v2.rewrite.XGraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.schema.SchemaNavigator;
import org.aksw.jenax.graphql.sparql.v2.util.ElementUtils;
import org.aksw.jenax.graphql.sparql.v2.util.GraphQlUtils;
import org.aksw.jenax.graphql.sparql.v2.util.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.vocabulary.RDF;

public abstract class GraphQlToSparqlConverterBase<K>
extends NodeVisitorStub {
    public static final CardinalityDirective DFT_CARDINALITY = new CardinalityDirective(false, true, false);
    protected Map<String, FragmentDefinition> nameToFragment;
    protected SchemaNavigator schemaNavigator;
    protected RewriteResult<K> rewriteResult;

    public GraphQlToSparqlConverterBase(Map<String, FragmentDefinition> nameToFragment, SchemaNavigator schemaNavigator) {
        this.nameToFragment = nameToFragment;
        this.schemaNavigator = schemaNavigator;
    }

    public RewriteResult<K> getRewriteResult() {
        return this.rewriteResult;
    }

    protected abstract K toKey(Field var1);

    protected abstract K toKey(Node var1);

    protected Node globalIdToSparql(String globalId) {
        return NodeFactory.createLiteralString((String)globalId);
    }

    public TraversalControl visitField(Field field, TraverserContext<graphql.language.Node> context) {
        TraversalControl result = !context.isVisited() ? this.enterField(field, context) : this.leaveField(field, context);
        return result;
    }

    public String readStateId(DirectivesContainer<?> directives) {
        Directive stateIdDirective = GraphQlUtils.expectAtMostOneDirective(directives, "globalId");
        String stateId = GraphQlUtils.getArgAsString(stateIdDirective, "id");
        return stateId;
    }

    public TraversalControl enterQuery(OperationDefinition node, TraverserContext<graphql.language.Node> context) {
        if (!context.isVisited()) {
            RewriteResult rr = (RewriteResult)context.getVarFromParents(RewriteResult.class);
            String stateId = this.readStateId((DirectivesContainer<?>)node);
            ElementNode rootElementNode = ElementNode.of("root", ((ConnectiveBuilder)((ConnectiveBuilder)Connective.newBuilder().element((Element)new ElementGroup()).connectVars(new Var[0])).targetVars(new Var[0])).build());
            rootElementNode.setIdentifier(stateId);
            AggStateBuilderObject aggStateBuilderRoot = new AggStateBuilderObject(false);
            rr.root = new GraphQlFieldRewrite(rootElementNode, aggStateBuilderRoot, true, (graphql.language.Node<?>)node);
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl leaveQuery(OperationDefinition node, TraverserContext<graphql.language.Node> context) {
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitOperationDefinition(OperationDefinition node, TraverserContext<graphql.language.Node> context) {
        TraversalControl result = "QUERY".equals(node.getOperation().name()) ? (!context.isVisited() ? this.enterQuery(node, context) : this.leaveQuery(node, context)) : super.visitOperationDefinition(node, context);
        return result;
    }

    public TraversalControl visitDocument(Document node, TraverserContext<graphql.language.Node> context) {
        if (!context.isVisited()) {
            RewriteResult rr = new RewriteResult();
            rr.map = new LinkedHashMap();
            this.rewriteResult = rr;
            context.setVar(RewriteResult.class, rr);
            context.setAccumulate(rr);
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl enterField(Field field, TraverserContext<graphql.language.Node> context) {
        this.processFieldOnEnter((graphql.language.Node<?>)field, field.getName(), field.getArguments(), (DirectivesContainer<?>)field, field.getSelectionSet(), context);
        return TraversalControl.CONTINUE;
    }

    public void processFieldOnEnter(graphql.language.Node<?> node, String nodeName, List<Argument> arguments, DirectivesContainer<?> directives, SelectionSet selectionSet, TraverserContext<graphql.language.Node> context) {
        boolean isEdgeField;
        ArrayMode arrayMode;
        AggStateBuilderObject abo;
        ElementNode elementNode;
        boolean isIndexField;
        JoinDirective joinDirective;
        Node typeNode;
        boolean isFragmentStart;
        boolean isRoot = XGraphQlUtils.isRootNode(node, context);
        FragmentCxtHolder fragmentCxtHolder = (FragmentCxtHolder)context.getVarFromParents(FragmentCxtHolder.class);
        FragmentCxt fragmentCxt = fragmentCxtHolder == null ? null : fragmentCxtHolder.cxt();
        boolean bl = isFragmentStart = fragmentCxt != null;
        if (isFragmentStart) {
            context.setVar(FragmentCxtHolder.class, (Object)new FragmentCxtHolder(null));
        }
        String stateId = this.readStateId(directives);
        Node globalIdNode = this.globalIdToSparql(stateId);
        Directive patternDir = GraphQlUtils.expectAtMostOneDirective(directives, "pattern");
        Connective connective = null;
        if (patternDir != null) {
            try {
                connective = XGraphQlUtils.parsePattern(patternDir, null);
            }
            catch (Exception e) {
                throw new RuntimeException("At field " + nodeName + ": Failed to process directive: " + String.valueOf(patternDir), e);
            }
        }
        Long offset = GraphQlUtils.getArgAsLong(arguments, "offset", null);
        Long limit = GraphQlUtils.getArgAsLong(arguments, "limit", null);
        List parentVars = null;
        String typeIri = JenaGraphQlUtils.parseRdfIri(nodeName, directives, XGraphQlConstants.type, "iri", "ns", null);
        Node node2 = typeNode = typeIri == null ? null : NodeFactory.createURI((String)typeIri);
        if (connective == null) {
            if (typeNode != null) {
                connective = ((ConnectiveBuilder)((ConnectiveBuilder)((ConnectiveBuilder)Connective.newBuilder().connectVars(Vars.s)).targetVars(Vars.s)).element((Element)ElementUtils.createElementTriple((Node)Vars.s, RDF.type.asNode(), typeNode))).build();
            } else {
                connective = ((ConnectiveBuilder)((ConnectiveBuilder)((ConnectiveBuilder)Connective.newBuilder().connectVarNames(new String[0])).targetVarNames(new String[0])).element((Element)new ElementGroup())).build();
                parentVars = List.of();
            }
        } else if (typeNode != null) {
            List<Var> targetVars = connective.getDefaultTargetVars();
            Var targetVar = targetVars.iterator().next();
            if (targetVars.size() != 1) {
                throw new RuntimeException("@class can only be used when there is a single target variable. Target variables are: " + String.valueOf(targetVars));
            }
            Element a2 = connective.getElement();
            ElementTriplesBlock b = ElementUtils.createElementTriple((Node)targetVar, RDF.type.asNode(), typeNode);
            Element merged = ElementUtils.flatGroup(new Element[]{a2, b});
            connective = Connective.of(connective.getConnectVars(), connective.getDefaultTargetVars(), merged);
        }
        List connectVars = connective.getConnectVars();
        ConditionDirective condition = XGraphQlUtils.parseCondition(directives);
        if (condition != null) {
            boolean applyFilter = true;
            String whenExprStr = condition.whenExprStr();
            HashMap<Var, Node> argMap = new HashMap<Var, Node>();
            if (whenExprStr != null) {
                Expr whenExpr = ExprUtils.parse((String)whenExprStr);
                Set whenExprVars = whenExpr.getVarsMentioned();
                BindingBuilder bb = BindingFactory.builder();
                for (Var v : whenExprVars) {
                    String argName = v.getName();
                    Argument arg = arguments.stream().filter(a -> a.getName().equals(argName)).findFirst().orElseThrow(() -> new RuntimeException("No such argument: " + argName));
                    Node n = GraphQlUtils.toNodeValue(arg.getValue()).asNode();
                    bb.add(v, n);
                    argMap.put(v, n);
                }
                Binding b = bb.build();
                NodeValue nv = ExprLib.evalOrNull((Expr)whenExpr, (Binding)b, null);
                applyFilter = XSDFuncOp.booleanEffectiveValue((NodeValue)nv);
            }
            if (condition.byExprStr() == null) {
                applyFilter = false;
            }
            if (applyFilter) {
                Connective filterConnective = GraphQlToSparqlConverterBase.filterToConnective(connective.getConnectVars(), condition, argMap);
                List<Var> filterVars = filterConnective.getConnectVars();
                List<Var> patternVars = connective.getDefaultTargetVars();
                if (patternVars.size() != filterVars.size()) {
                    throw new RuntimeException("Filter variables do not connect to the pattern: filterVars: " + String.valueOf(filterVars) + " patternVars: " + String.valueOf(patternVars));
                }
                HashMap<Var, Object> varMap = new HashMap<Var, Object>();
                for (Var v : filterConnective.getMentionedVars()) {
                    String varName = v.getName();
                    if (varName.matches("^[0-9]+$")) {
                        int argIdx = Integer.parseInt(varName.substring(1));
                        Argument arg = arguments.get(argIdx);
                        Value value = arg.getValue();
                        Node n = GraphQlUtils.toNodeValue(value).asNode();
                        varMap.put(v, n);
                        continue;
                    }
                    varMap.put(v, Var.alloc((String)(stateId + "_" + v.getVarName())));
                }
                for (int i = 0; i < filterVars.size(); ++i) {
                    Var filterVar = filterVars.get(i);
                    Var patternVar = patternVars.get(i);
                    varMap.put(filterVar, patternVar);
                }
                Connective fConn = filterConnective.applyNodeTransform((NodeTransform)new NodeTransformSubst(varMap));
                Element a3 = connective.getElement();
                Element b = fConn.getElement();
                Element merged = ElementUtils.flatGroup(a3, b);
                connective = Connective.of(connective.getConnectVars(), connective.getDefaultTargetVars(), merged);
            }
        }
        if ((joinDirective = XGraphQlUtils.parseJoin(directives)) != null) {
            if (joinDirective.parentVars() != null) {
                parentVars = Var.varList(joinDirective.parentVars());
            }
            if (joinDirective.thisVars() != null) {
                connectVars = Var.varList(joinDirective.thisVars());
            }
        }
        AggStateBuilderEdge edgeBuilder = null;
        AggStateBuilderTransitionMatch transitionBuilder = null;
        IndexDirective index = XGraphQlUtils.parseIndex(directives);
        boolean bl2 = isIndexField = index != null;
        if (index != null) {
            String keyExprStr = index.keyExpr();
            if (keyExprStr == null) {
                throw new RuntimeException("@index(by: \" ... required argument missing ... \")");
            }
            Expr keyExpr = ExprUtils.parse((String)index.keyExpr());
            List<Expr> sortExprs = keyExpr.getVarsMentioned().stream().map(ExprVar::new).map(x -> x).toList();
            Set<Var> visibleVars = connective.getVisibleVars();
            Element before = connective.getElement();
            Query query = QueryUtils.elementToQuery(before);
            ElementSubQuery after = new ElementSubQuery(query);
            for (Expr sortExpr : sortExprs) {
                query.addOrderBy(sortExpr, 1);
            }
            connective = ((ConnectiveBuilder)((ConnectiveBuilder)Connective.newBuilder().element((Element)after).connectVars(connectVars)).targetVars(connective.getDefaultTargetVars())).build();
            BiFunction<Binding, FunctionEnv, Object> indexMapper = (input, env) -> {
                NodeValue nv = keyExpr.eval(input, env);
                Node n = nv.asNode();
                K k = this.toKey(n);
                return k;
            };
            NodeValue oneIfExpr = index.oneIf() == null ? NodeValue.FALSE : ExprUtils.parse((String)index.oneIf());
            BiPredicate<Binding, FunctionEnv> oneIfTest = (arg_0, arg_1) -> GraphQlToSparqlConverterBase.lambda$processFieldOnEnter$4((Expr)oneIfExpr, arg_0, arg_1);
            transitionBuilder = edgeBuilder = new AggStateBuilderMap(globalIdNode, indexMapper, oneIfTest);
        }
        List<Var> targetVars = connective.getDefaultTargetVars();
        ElementNode localRoot = elementNode = ElementNode.of(connective);
        elementNode.setIdentifier(stateId);
        elementNode.setLimit(limit);
        elementNode.setOffset(offset);
        ElementNode parentNode = (ElementNode)context.getVarFromParents(ElementNode.class);
        AggStateBuilderTransitionBase parentAggBuilder = (AggStateBuilderTransitionBase)context.getVarFromParents(AggStateBuilderTransitionBase.class);
        context.setVar(ElementNode.class, (Object)elementNode);
        boolean isPatternFree = connective.isEmpty();
        if (isPatternFree) {
            List<Var> parentTargetVars = parentNode == null ? null : parentNode.getEffectiveTargetVars();
            elementNode.setLocalTargetVars(parentTargetVars);
        }
        if (isFragmentStart) {
            parentNode.addChild(parentVars, elementNode, connectVars);
        } else if (parentNode != null) {
            parentNode.addChild(parentVars, elementNode, connectVars);
        }
        boolean isBindValue = false;
        if (directives.hasDirective("to")) {
            List<Var> parentTargetVars = elementNode.getParentLink().parent().getEffectiveTargetVars();
            targetVars = parentTargetVars.stream().map(parentTargetVar -> {
                Var localVar = this.processBind(node, elementNode, null, (Expr)new ExprVar(parentTargetVar));
                return localVar;
            }).toList();
            elementNode.setLocalTargetVars(targetVars);
            isBindValue = true;
        }
        for (Directive directive : directives.getDirectives("bind")) {
            BindDirective bind = BindDirective.PARSER.parser(directive);
            Expr expr = bind.parseExpr();
            Var bindVar = this.processBind(node, elementNode, bind.varName(), expr);
            if (!connective.isEmpty() && !Boolean.TRUE.equals(bind.isTarget())) continue;
            targetVars = List.of(bindVar);
            elementNode.setLocalTargetVars(targetVars);
            isBindValue = true;
        }
        AggStateBuilder tmpMapper = parentAggBuilder == null ? null : parentAggBuilder.getTargetNodeMapper();
        boolean isParentFieldArray = tmpMapper instanceof AggStateBuilderObject && (abo = (AggStateBuilderObject)tmpMapper).isArray();
        boolean isArray = directives.hasDirective("array");
        ArrayMode arrayMode2 = arrayMode = isParentFieldArray ? ArrayMode.FLAT : ArrayMode.OFF;
        if (ArrayMode.FLAT.equals((Object)arrayMode) && isArray) {
            arrayMode = ArrayMode.NESTED;
        }
        if (isRoot) {
            RewriteResult rewriteResult = (RewriteResult)context.getVarFromParents(RewriteResult.class);
            rewriteResult.root.rootElementNode().addChild(List.of(), elementNode, List.of());
        }
        CardinalityDirective cardinality = GraphQlToSparqlConverterBase.processCardinality(directives, context);
        GraphDirective graph = GraphQlToSparqlConverterBase.processGraph(directives, context);
        if (graph != null) {
            if (!graph.isSelf() && graph.isCascade()) {
                throw new RuntimeException("@graph(self: false, cascade: true) must be handled by a preprocessor that pushes the directive to each child.");
            }
            ElementTransform elementTransform = GraphQlToSparqlConverterBase.convert(graph);
            if (graph.isCascade()) {
                localRoot.addTreeTransform(elementTransform);
            } else {
                localRoot.addLocalTransform(elementTransform);
            }
        }
        List subSelections = selectionSet == null ? Collections.emptyList() : selectionSet.getSelectionsOfType(Selection.class);
        boolean isLeafField = subSelections.isEmpty();
        boolean isSingle = cardinality.isOne();
        CardinalityDirective thisCardinality = (CardinalityDirective)context.getVar(CardinalityDirective.class);
        if (isPatternFree || isBindValue) {
            isSingle = thisCardinality == null ? true : thisCardinality.isOne();
        }
        boolean skipIfNull = directives.hasDirective("skipIfNull");
        Object key = null;
        if (node instanceof Field) {
            Field f = (Field)node;
            key = this.toKey(f);
        }
        AggStateBuilder targetAggBuilder = null;
        if (!isLeafField) {
            AggStateBuilderObject objectBuilder;
            targetAggBuilder = objectBuilder = new AggStateBuilderObject(isArray);
        }
        if (isEdgeField = isRoot ? true : true) {
            if (isIndexField) {
                if (isLeafField) {
                    mapper = targetVars.size() == 1 ? Bind.var(targetVars.get(0)) : Bind.vars(targetVars);
                    targetAggBuilder = AggStateBuilderLiteral.of(mapper);
                    this.setAggResult(context, targetAggBuilder);
                }
                edgeBuilder.setTargetBuilder(targetAggBuilder);
            } else {
                if (key == null) {
                    throw new RuntimeException("Failed to obtain a key for field: " + nodeName);
                }
                if (isLeafField) {
                    Objects.requireNonNull(key);
                    mapper = targetVars.size() == 1 ? Bind.var(targetVars.get(0)) : Bind.vars(targetVars);
                    AggStateBuilderLiteralProperty<Binding, FunctionEnv, Object, Node> propertyBuilder = AggStateBuilderLiteralProperty.of(globalIdNode, key, isSingle, skipIfNull, arrayMode, mapper);
                    transitionBuilder = propertyBuilder;
                    this.setAggResult(context, propertyBuilder);
                } else {
                    AggStateBuilderProperty propertyBuilder = AggStateBuilderProperty.of(globalIdNode, key, arrayMode);
                    propertyBuilder.setTargetBuilder(targetAggBuilder);
                    propertyBuilder.setSingle(isSingle);
                    transitionBuilder = propertyBuilder;
                    edgeBuilder = propertyBuilder;
                }
            }
            if (parentAggBuilder != null) {
                AggStateBuilderObjectLikeBase tmp = (AggStateBuilderObjectLikeBase)parentAggBuilder.getTargetNodeMapper();
                tmp.addMember(transitionBuilder);
            }
            if (edgeBuilder != null) {
                this.setAggTransition(context, edgeBuilder);
            }
        }
    }

    private Var processBind(graphql.language.Node<?> node, ElementNode elementNode, String bindVarName, Expr expr) {
        Set vars = expr.getVarsMentioned();
        for (Var var : vars) {
            ElementNode varSource = elementNode.findVarInAncestors(var);
            if (varSource != null) continue;
            throw new RuntimeException("Could not resolve variable " + String.valueOf(var) + " at " + String.valueOf(node));
        }
        if (bindVarName == null) {
            bindVarName = "bindvar_" + (elementNode.getBinds().size() + 1);
        }
        Var bindVar = Var.alloc((String)bindVarName);
        elementNode.getBinds().add(bindVar, expr);
        return bindVar;
    }

    public TraversalControl leaveField(Field field, TraverserContext<graphql.language.Node> context) {
        boolean isRoot = XGraphQlUtils.isRootNode(field, context);
        if (isRoot) {
            AggStateBuilderEdge matchBuilder;
            AggStateBuilderEdge eb;
            RewriteResult rewriteResult = (RewriteResult)context.getVarFromParents(RewriteResult.class);
            AggStateBuilderTransitionBase<Binding, FunctionEnv, K, Node> transBuilder = this.getAggTransition(context);
            AggStateBuilderEdge edgeBuilder = transBuilder instanceof AggStateBuilderEdge ? (eb = (AggStateBuilderEdge)transBuilder) : null;
            AggStateBuilder targetMapper = edgeBuilder == null ? null : edgeBuilder.getTargetNodeMapper();
            ElementNode elementNode = (ElementNode)context.getVar(ElementNode.class);
            boolean isSingle = edgeBuilder != null ? edgeBuilder.isHidden() : true;
            AggStateBuilderTransitionMatch aggStateBuilderTransitionMatch = matchBuilder = edgeBuilder != null ? edgeBuilder : (AggStateBuilderTransitionMatch)this.getAggResult(context);
            if (targetMapper != null) {
                GraphQlFieldRewrite singleResult = new GraphQlFieldRewrite(elementNode, targetMapper, isSingle, (graphql.language.Node<?>)field);
                rewriteResult.map.put(field.getName(), singleResult);
            }
            AggStateBuilderObject objBuilder = (AggStateBuilderObject)rewriteResult.root().rootAggBuilder();
            K key = this.toKey(field);
            Objects.requireNonNull(key);
            Objects.requireNonNull(matchBuilder);
            objBuilder.addMember(matchBuilder);
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitInlineFragment(InlineFragment node, TraverserContext<graphql.language.Node> context) {
        if (!context.isVisited()) {
            String stateId = this.readStateId((DirectivesContainer<?>)node);
            this.processInlineFragment(node, context, stateId);
        }
        return super.visitInlineFragment(node, context);
    }

    private void processInlineFragment(InlineFragment node, TraverserContext<graphql.language.Node> context, String stateId) {
        Node globalIdNode = this.globalIdToSparql(stateId);
        ConditionDirective condition = XGraphQlUtils.parseCondition(node);
        Objects.requireNonNull(condition.byExprStr(), "@filter(if: 'required key absent')");
        ElementNode parentEltNode = (ElementNode)context.getVarFromParents(ElementNode.class);
        Connective connective = GraphQlToSparqlConverterBase.filterToConnective(parentEltNode.getConnective().getDefaultTargetVars(), condition, null);
        List<Var> parentVars = connective.getConnectVars();
        List<Var> thisVars = connective.getDefaultTargetVars();
        ElementNode thisElementNode = ElementNode.of(connective);
        thisElementNode.setIdentifier(stateId);
        parentEltNode.addChild(parentVars, thisElementNode, thisVars);
        context.setVar(ElementNode.class, (Object)thisElementNode);
        FragmentCxt cxt = new FragmentCxt((graphql.language.Node)node, thisVars);
        context.setVar(FragmentCxtHolder.class, (Object)new FragmentCxtHolder(cxt));
        AggStateBuilderTransitionBase parentAggBuilder = (AggStateBuilderTransitionBase)context.getVarFromParents(AggStateBuilderTransitionBase.class);
        AggStateBuilderFragmentHead aggStateBuilder = new AggStateBuilderFragmentHead(globalIdNode);
        aggStateBuilder.setTargetBuilder(new AggStateBuilderFragmentBody());
        this.setAggTransition(context, aggStateBuilder);
        if (parentAggBuilder != null) {
            AggStateBuilderObject tmp = (AggStateBuilderObject)parentAggBuilder.getTargetNodeMapper();
            tmp.addMember(aggStateBuilder);
        }
    }

    protected static Connective filterToConnective(List<Var> connectVars, ConditionDirective condition, Map<Var, Node> binding) {
        Expr byExpr = null;
        Set byExprVars = null;
        List parentVars = null;
        List thisVars = null;
        Connective connective = null;
        if (condition != null) {
            List<String> thisVarNames;
            byExpr = ExprUtils.parse((String)condition.byExprStr());
            if (binding != null && !binding.isEmpty()) {
                byExpr = byExpr.applyNodeTransform((NodeTransform)new NodeTransformSubst(binding));
            }
            byExprVars = byExpr.getVarsMentioned();
            List<String> parentVarNames = condition.parentVars();
            if (parentVarNames != null) {
                parentVars = Var.varList(parentVarNames);
            }
            if ((thisVarNames = condition.thisVars()) != null) {
                thisVars = Var.varList(thisVarNames);
            }
        }
        if (parentVars == null) {
            parentVars = connectVars;
        }
        if (byExprVars != null && thisVars == null) {
            if (byExprVars.size() == 1) {
                thisVars = List.of((Var)byExprVars.iterator().next());
            } else {
                throw new RuntimeException("@filter(this: [varlist]) must be given if an expression has more than 1 variable");
            }
        }
        connective = byExpr != null ? ((ConnectiveBuilder)((ConnectiveBuilder)Connective.newBuilder().element((Element)new ElementFilter(byExpr)).connectVars(parentVars)).targetVars(thisVars)).build() : ((ConnectiveBuilder)((ConnectiveBuilder)Connective.newBuilder().element((Element)new ElementBind(Vars.z, (Expr)new ExprVar(Vars.x))).connectVars(Vars.x)).targetVars(Vars.z)).build();
        return connective;
    }

    protected void setAggTransition(TraverserContext<graphql.language.Node> context, AggStateBuilderTransitionBase<Binding, FunctionEnv, K, Node> aggStateBuilder) {
        context.setVar(AggStateBuilderTransitionBase.class, aggStateBuilder);
    }

    protected AggStateBuilderTransitionBase<Binding, FunctionEnv, K, Node> getAggTransition(TraverserContext<graphql.language.Node> context) {
        AggStateBuilderTransitionBase result = (AggStateBuilderTransitionBase)context.getVar(AggStateBuilderTransitionBase.class);
        return result;
    }

    protected void setAggResult(TraverserContext<graphql.language.Node> context, AggStateBuilder<Binding, FunctionEnv, K, Node> aggStateBuilder) {
        context.setVar(AggStateBuilder.class, aggStateBuilder);
    }

    protected AggStateBuilder<Binding, FunctionEnv, K, Node> getAggResult(TraverserContext<graphql.language.Node> context) {
        AggStateBuilder result = (AggStateBuilder)context.getVar(AggStateBuilder.class);
        return result;
    }

    public TraversalControl visitFragmentSpread(FragmentSpread node, TraverserContext<graphql.language.Node> context) {
        return TraversalControl.CONTINUE;
    }

    public static CardinalityDirective processCardinality(DirectivesContainer<?> directives, TraverserContext<graphql.language.Node> context) {
        CardinalityDirective cardinality = null;
        cardinality = XGraphQlUtils.parseCardinality(directives);
        if (!context.isVisited() && cardinality != null && cardinality.isCascade()) {
            context.setVar(CardinalityDirective.class, (Object)cardinality);
        }
        if (cardinality != null && !cardinality.isSelf()) {
            cardinality = null;
        }
        if (cardinality == null) {
            cardinality = (CardinalityDirective)context.getVarFromParents(CardinalityDirective.class);
        }
        if (cardinality == null) {
            cardinality = DFT_CARDINALITY;
        }
        return cardinality;
    }

    public static GraphDirective processGraph(DirectivesContainer<?> field, TraverserContext<graphql.language.Node> context) {
        GraphDirective graphDirective = null;
        if (!context.isVisited() && (graphDirective = XGraphQlUtils.parseGraph(field)) != null) {
            context.setVar(GraphDirective.class, (Object)graphDirective);
        }
        return graphDirective;
    }

    public static ElementTransform convert(GraphDirective graph) {
        ElementTransformGraph result;
        String varName = graph.getVarName();
        List<String> iris = graph.getGraphIris();
        if (varName == null && iris != null && iris.size() == 1) {
            Node node = NodeFactory.createURI((String)iris.get(0));
            result = new ElementTransformGraph(node);
        } else {
            result = new ElementTransformGraph((Node)Var.alloc((String)"x"));
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$processFieldOnEnter$4(Expr oneIfExpr, Binding input, FunctionEnv env) {
        NodeValue nv = oneIfExpr.eval(input, env);
        boolean r = NodeValue.TRUE.equals((Object)nv);
        return r;
    }
}

