/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.io;

import java.util.Objects;
import java.util.Stack;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonProviderApi;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriter;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriterInMemory;
import org.aksw.jenax.graphql.sparql.v2.util.ObjectUtils;

public class ObjectNotationWriterViaGon<T, K, V>
implements ObjectNotationWriterInMemory<T, K, V> {
    protected GonProviderApi<T, K, V> provider;
    protected Stack<Object> stack = new Stack();
    protected K pendingKey;
    protected T product;

    protected ObjectNotationWriterViaGon(GonProviderApi<T, K, V> provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public static <T, K, V> ObjectNotationWriterViaGon<T, K, V> of(GonProviderApi<T, K, V> provider) {
        return new ObjectNotationWriterViaGon<T, K, V>(provider);
    }

    @Override
    public T getProduct() {
        return this.product;
    }

    @Override
    public void clear() {
        this.product = null;
    }

    @Override
    public void flush() {
    }

    protected void put(Object elt) {
        if (this.pendingKey != null) {
            Object current = this.stack.peek();
            this.provider.setProperty(current, this.pendingKey, elt);
            this.pendingKey = null;
        } else if (this.stack.isEmpty()) {
            Object tmp = elt;
            this.product = tmp;
        } else {
            Object current = this.stack.peek();
            if (this.provider.isArray(current)) {
                this.provider.addElement(current, elt);
            } else {
                throw new IllegalStateException("Illegal json structure: current top of stack: " + String.valueOf(ObjectUtils.getClass(current)) + ", attempted contribution: " + String.valueOf(ObjectUtils.getClass(elt)));
            }
        }
    }

    @Override
    public ObjectNotationWriter<K, V> beginArray() {
        T elt = this.provider.newArray();
        this.put(elt);
        this.stack.add(elt);
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> endArray() {
        Object elt = this.stack.peek();
        if (!this.provider.isArray(elt)) {
            throw new IllegalStateException();
        }
        this.stack.pop();
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> beginObject() {
        T elt = this.provider.newObject();
        this.put(elt);
        this.stack.add(elt);
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> endObject() {
        Object elt = this.stack.peek();
        if (!this.provider.isObject(elt)) {
            throw new IllegalStateException();
        }
        this.stack.pop();
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> name(K key) {
        Object elt = this.stack.peek();
        if (!this.provider.isObject(elt)) {
            throw new IllegalStateException("Element under construction is not an object.");
        }
        if (this.pendingKey != null) {
            throw new IllegalStateException("A pending name has already been set.");
        }
        this.pendingKey = key;
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> value(V value) {
        Object elt = this.provider.newDirectLiteral(value);
        this.put(elt);
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> nullValue() {
        T nil = this.provider.newNull();
        this.put(nil);
        return this;
    }
}

