/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.gon.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonArray;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonElement;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonElementBase;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonElementVisitor;
import org.aksw.jenax.graphql.sparql.v2.gon.model.ParentLinkArray;
import org.aksw.jenax.graphql.sparql.v2.gon.model.ParentLinkArrayImpl;

public class GonArrayImpl<K, V>
extends GonElementBase<K, V>
implements GonArray<K, V> {
    protected List<GonElement<K, V>> elements;

    public GonArrayImpl() {
        this(new ArrayList<GonElement<K, V>>());
    }

    protected GonArrayImpl(List<GonElement<K, V>> elements) {
        this.elements = elements;
    }

    @Override
    public <T> T accept(GonElementVisitor<K, V, T> visitor) {
        T result = visitor.visit(this);
        return result;
    }

    @Override
    public GonArray<K, V> add(GonElement<K, V> element) {
        int i = this.elements.size();
        ((GonElementBase)element).setParent(new ParentLinkArrayImpl(this, i));
        this.elements.add(element);
        return this;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public GonArray<K, V> addAll(GonArray<K, V> other) {
        other.forEach(this.elements::add);
        return this;
    }

    public GonArray<K, V> addAll(Collection<? extends GonElement<K, V>> c) {
        this.elements.addAll(c);
        return this;
    }

    @Override
    public GonElement<K, V> get(int index) {
        return this.elements.get(index);
    }

    @Override
    public Iterator<GonElement<K, V>> iterator() {
        return this.elements.iterator();
    }

    @Override
    public GonArray<K, V> set(int index, GonElement<K, V> element) {
        GonElement<K, V> elt = this.elements.get(index);
        if (elt != null) {
            GonElementBase x = (GonElementBase)elt;
            x.setParent(null);
            ((GonElementBase)element).setParent(new ParentLinkArrayImpl(this, index));
        }
        return this;
    }

    @Override
    public GonArray<K, V> remove(int index) {
        this.elements.remove(index);
        ListIterator<GonElement<K, V>> it = this.elements.listIterator(index);
        while (it.hasNext()) {
            GonElementBase elt = (GonElementBase)it.next();
            ParentLinkArray oldLink = elt.getParent().asArrayLink();
            elt.setParent(new ParentLinkArrayImpl(oldLink.getParent(), oldLink.getIndex() - 1));
        }
        return this;
    }
}

