/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.api2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.aksw.jenax.graphql.sparql.v2.api2.Connective;
import org.aksw.jenax.graphql.sparql.v2.api2.ConnectiveNode;
import org.aksw.jenax.graphql.sparql.v2.api2.ConnectiveVisitor;
import org.aksw.jenax.graphql.sparql.v2.api2.FragmentSpread;
import org.aksw.jenax.graphql.sparql.v2.api2.Selection;
import org.aksw.jenax.graphql.sparql.v2.model.ElementNode;

public class ConnectiveVisitorToString
implements ConnectiveVisitor<Void> {
    protected PrintStream out;
    protected String indent;

    public ConnectiveVisitorToString(PrintStream out, String indent) {
        this.out = out;
        this.indent = indent;
    }

    public static String toString(ConnectiveNode node) {
        String result;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (PrintStream ps = new PrintStream((OutputStream)baos, false, StandardCharsets.UTF_8);){
                ConnectiveVisitorToString visitor = new ConnectiveVisitorToString(ps, "");
                node.accept(visitor);
                ps.flush();
            }
            baos.flush();
            result = baos.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void print(PrintStream out, String baseIndent, String baseText, String value) {
        if (value == null) {
            out.print(baseIndent);
            out.println(Objects.toString(value));
        } else {
            String blank = " ".repeat(baseText.length());
            String[] strs = value.split(System.lineSeparator());
            for (int i = 0; i < strs.length; ++i) {
                out.print(baseIndent);
                out.print(i == 0 ? baseText : blank);
                out.println(strs[i]);
            }
        }
    }

    @Override
    public Void visit(Connective connective) {
        ConnectiveVisitorToString.print(this.out, this.indent + "|  ", "element ", Objects.toString(connective.getElement()));
        this.out.println(this.indent + "|  default targets " + String.valueOf(connective.getDefaultTargetVars()));
        return null;
    }

    @Override
    public Void visit(ElementNode field) {
        Connective connective = field.getConnective();
        String parentStr = field.getJoinLink() == null ? "root" : "parent." + String.valueOf(field.getJoinLink());
        this.out.println(this.indent + "|- connects " + parentStr);
        this.visit(connective);
        this.visitSelections(field.getSelections());
        return null;
    }

    protected void visitSelections(Collection<Selection> selections) {
        Iterator<Selection> it = selections.iterator();
        int i = 0;
        String baseIndent = this.indent;
        while (it.hasNext()) {
            Selection subField = it.next();
            this.out.println(this.indent + "|- field[" + i + "] " + subField.getName());
            String indentBackup = this.indent;
            String nextIndent = it.hasNext() ? "|  " : "   ";
            String tmp = this.indent + nextIndent;
            this.indent = tmp;
            subField.accept(this);
            this.indent = indentBackup;
            ++i;
        }
        if (selections.isEmpty()) {
            this.out.println(baseIndent);
        }
    }

    @Override
    public Void visit(FragmentSpread fragmentSpread) {
        this.out.println(this.indent + "|- spreads " + fragmentSpread.getName() + " " + String.valueOf(fragmentSpread.getFragmentToInput()));
        this.visitSelections(fragmentSpread.getFragment().getSelections());
        return null;
    }
}

