/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.api2;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.aksw.jenax.graphql.sparql.v2.api2.Connective;
import org.aksw.jenax.graphql.sparql.v2.api2.HasConnectVarBuilder;
import org.aksw.jenax.graphql.sparql.v2.api2.HasTargetVarBuilder;
import org.aksw.jenax.graphql.sparql.v2.api2.SparqlPathTraversable;
import org.aksw.jenax.graphql.sparql.v2.api2.VarHelper;
import org.aksw.jenax.graphql.sparql.v2.util.ElementUtils;
import org.aksw.jenax.graphql.sparql.v2.util.Vars;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.lang.arq.ParserARQ;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementPathBlock;

public class ConnectiveBuilder<T extends ConnectiveBuilder<T>>
implements HasTargetVarBuilder<T>,
HasConnectVarBuilder<T>,
SparqlPathTraversable<T> {
    protected Element element;
    protected List<Var> connectVars;
    protected List<Var> defaultTargetVars;

    public T element(String elementStr) {
        Element elt;
        this.element = elt = ParserARQ.parseElement((String)elementStr);
        return (T)((ConnectiveBuilder)this.self());
    }

    public T element(Element element) {
        Objects.requireNonNull(element);
        this.element = element;
        return (T)((ConnectiveBuilder)this.self());
    }

    @Override
    public void setConnectVars(List<Var> connectVars) {
        this.connectVars = connectVars;
    }

    @Override
    public void setTargetVars(List<Var> targetVars) {
        this.defaultTargetVars = targetVars;
    }

    @Override
    public T step(Path path) {
        ElementPathBlock elt;
        if (path instanceof P_Path0) {
            P_Path0 p0 = (P_Path0)path;
            elt = ElementUtils.createElementTriple((Node)Vars.s, p0.getNode(), (Node)Vars.o, p0.isForward());
        } else {
            elt = ElementUtils.createElementPath((Node)Vars.s, path, (Node)Vars.o);
        }
        this.element((Element)elt);
        this.connectVars(Vars.s);
        this.targetVars(Vars.o);
        return (T)((ConnectiveBuilder)this.self());
    }

    public Connective build() {
        List<Var> vars;
        Objects.requireNonNull(this.element);
        List<Var> finalConnectVars = this.connectVars;
        List<Var> finalTargetVars = this.defaultTargetVars;
        if ((finalConnectVars == null || finalTargetVars == null) && (vars = ElementUtils.inferConnecVars(this.element)) != null) {
            if (finalConnectVars == null) {
                finalConnectVars = List.of(vars.get(0));
            }
            if (finalTargetVars == null) {
                finalTargetVars = List.of(vars.get(vars.size() - 1));
            }
        }
        Objects.requireNonNull(finalConnectVars);
        Op op = Algebra.compile((Element)this.element);
        Set<Var> visibleVars = VarHelper.visibleVars(op);
        Set absentConnectVars = SetUtils.difference(new HashSet<Var>(finalConnectVars), visibleVars);
        if (!absentConnectVars.isEmpty()) {
            throw new RuntimeException("The connectVars " + String.valueOf(absentConnectVars) + " are not present or visible in the pattern: " + String.valueOf(this.element));
        }
        Set absentTargetVars = SetUtils.difference(new HashSet<Var>(finalTargetVars), visibleVars);
        if (!absentTargetVars.isEmpty()) {
            throw new RuntimeException("The targetVars " + String.valueOf(absentTargetVars) + " are not present or visible in the pattern: " + String.valueOf(this.element));
        }
        return new Connective(this.element, finalConnectVars, finalTargetVars, op, visibleVars);
    }
}

