/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.algebra.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.engine.join.JoinKey;

public class TransformDeriveOrderBy
extends TransformCopy {
    public Op transform(OpUnion opUnion, Op left, Op right) {
        return super.transform(opUnion, left, right);
    }

    private static List<Op> flattenUnion(Op op) {
        ArrayList<Op> result = new ArrayList<Op>();
        TransformDeriveOrderBy.flattenUnion(op, result);
        return result;
    }

    private static void flattenUnion(Op op, List<Op> outOps) {
        if (op instanceof OpUnion) {
            OpUnion u = (OpUnion)op;
            TransformDeriveOrderBy.flattenUnion(u.getLeft(), outOps);
            TransformDeriveOrderBy.flattenUnion(u.getRight(), outOps);
        } else if (op instanceof OpDisjunction) {
            OpDisjunction d = (OpDisjunction)op;
            d.getElements().forEach(x -> TransformDeriveOrderBy.flattenUnion(x, outOps));
        } else {
            outOps.add(op);
        }
    }

    public Op transform(OpLateral opLateral, Op left, Op right) {
        Set visibleVarsLhs = OpVars.visibleVars((Op)left);
        List<Op> rhs = TransformDeriveOrderBy.flattenUnion(right);
        System.err.println("Join keys for " + String.valueOf(left));
        for (Op rhsOp : rhs) {
            HashSet mentionedVarsRhs = new HashSet(OpVars.mentionedVars((Op)rhsOp));
            JoinKey jk = JoinKey.create((Collection)visibleVarsLhs, mentionedVarsRhs);
            System.out.println("  with " + String.valueOf(rhsOp) + ": " + String.valueOf(jk));
        }
        return super.transform(opLateral, left, right);
    }

    public static void main(String[] args) {
        String queryStr = "SELECT  *\nWHERE\n  {   { BIND(\"state_0\" AS ?state)}\n    UNION\n      { { SELECT  *\n          WHERE\n            { { SELECT  ?field1_s\n                WHERE\n                  { ?field1_s  <http://www.wikidata.org/prop/direct/P31>  <http://www.wikidata.org/entity/Q11424>\n                    FILTER EXISTS { ?field1_s  <http://www.w3.org/2000/01/rdf-schema#label>  ?l\n                                    FILTER langMatches(lang(?l), \"en\")\n                                    FILTER contains(lcase(str(?l)), lcase(\"die hard\"))\n                                  }\n                  } ORDER BY ?field1_s\n              }\n            }\n          LIMIT   2\n        }\n        LATERAL\n          {   { BIND(\"state_1\" AS ?state)\n                BIND(?field1_s AS ?v_0)\n              }\n            UNION\n              { BIND(\"state_2\" AS ?state)\n                BIND(?field1_s AS ?field1_field1_bindvar_1)\n                BIND(?field1_field1_bindvar_1 AS ?v_0)\n              }\n            UNION\n              { BIND(\"state_3\" AS ?state)\n                ?field1_s  <http://www.w3.org/2000/01/rdf-schema#label>  ?field1_field2_l\n                FILTER ( lang(?field1_field2_l) = \"en\" )\n                BIND(?field1_s AS ?v_0)\n                BIND(?field1_field2_l AS ?v_1)\n              }\n            UNION\n              { BIND(\"state_4\" AS ?state)\n                ?field1_s  <http://schema.org/description>  ?field1_field3_l\n                FILTER ( lang(?field1_field3_l) = \"en\" )\n                BIND(?field1_s AS ?v_0)\n                BIND(?field1_field3_l AS ?v_1)\n              }\n            UNION\n              { BIND(\"state_5\" AS ?state)\n                { SELECT  ?field1_s ?field1_field4_o\n                  WHERE\n                    { ?field1_s  <http://www.wikidata.org/prop/direct/P18>  ?field1_field4_o }\n                  ORDER BY ?field1_field4_o\n                  LIMIT   1\n                }\n                BIND(?field1_s AS ?v_0)\n                BIND(?field1_field4_o AS ?v_1)\n              }\n            UNION\n              { BIND(\"state_6\" AS ?state)\n                { SELECT  ?field1_s (<http://www.w3.org/2001/XMLSchema#gYear>(MAX(?o)) AS ?field1_field5_date)\n                  WHERE\n                    { ?field1_s  <http://www.wikidata.org/prop/direct/P577>  ?o }\n                  GROUP BY ?field1_s\n                }\n                BIND(?field1_s AS ?v_0)\n                BIND(?field1_field5_date AS ?v_1)\n              }\n            UNION\n              { BIND(\"state_7\" AS ?state)\n                { SELECT  ?field1_s ?field1_field6_id\n                  WHERE\n                    { ?field1_s  <http://www.wikidata.org/prop/direct/P1874>  ?o\n                      BIND(IRI(concat(\"https://www.netflix.com/title/\", str(?o))) AS ?field1_field6_id)\n                    }\n                }\n                BIND(?field1_s AS ?v_0)\n                BIND(?field1_field6_id AS ?v_1)\n              }\n            UNION\n              { BIND(\"state_8\" AS ?state)\n                { SELECT  ?field1_s (MIN(?o) AS ?field1_field7_age)\n                  WHERE\n                    { ?field1_s !<file:///p>/<http://www.wikidata.org/prop/direct/P2899> ?o }\n                  GROUP BY ?field1_s\n                }\n                BIND(?field1_s AS ?v_0)\n                BIND(?field1_field7_age AS ?v_1)\n              }\n            UNION\n              { BIND(\"state_9\" AS ?state)\n                { SELECT DISTINCT  ?field1_s (str(?l) AS ?field1_field8_x)\n                  WHERE\n                    { ?field1_s <http://www.wikidata.org/prop/direct/P136>/<http://www.w3.org/2000/01/rdf-schema#label> ?l\n                      FILTER langMatches(lang(?l), \"en\")\n                    }\n                }\n                BIND(?field1_s AS ?v_0)\n                BIND(?field1_field8_x AS ?v_1)\n              }}\n      }}\n\n";
        Query beforeQuery = QueryFactory.create((String)queryStr);
        Op beforeOp = Algebra.compile((Query)beforeQuery);
        Op afterOp = Transformer.transform((Transform)new TransformDeriveOrderBy(), (Op)beforeOp);
        Query afterQuery = OpAsQuery.asQuery((Op)afterOp);
    }
}

