/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccContext;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccState;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateGon;

public class AccStateDriver<I, E, K, V> {
    protected AccContext<K, V> context;
    protected AccStateGon<I, E, K, V> currentState;
    protected Object currentSource;
    protected long sourcesSeen = 0L;
    protected boolean isSingle;
    protected BiFunction<I, E, ?> inputToStateId;
    boolean hasPendingInput = false;
    protected Object pendingInputStateId;
    protected I pendingInput;
    protected E pendingEnv;

    protected AccStateDriver(AccContext<K, V> context, AccStateGon<I, E, K, V> rootAcc, boolean isSingle, BiFunction<I, E, ?> inputToStateId) {
        if (rootAcc.getParent() != null) {
            throw new IllegalArgumentException("Root accumulator must not have a parent");
        }
        this.currentState = rootAcc;
        this.isSingle = isSingle;
        this.inputToStateId = inputToStateId;
        this.setContext(context);
    }

    public static <I, E, K, V> AccStateDriver<I, E, K, V> of(AccContext<K, V> context, AccStateGon<I, E, K, V> rootAcc, boolean isSingle, BiFunction<I, E, ?> inputToStateId) {
        return new AccStateDriver<I, E, K, V>(context, rootAcc, isSingle, inputToStateId);
    }

    public BiFunction<I, E, ?> getInputToStateId() {
        return this.inputToStateId;
    }

    public AccContext<K, V> getContext() {
        return this.context;
    }

    public long getSourcesSeen() {
        return this.sourcesSeen;
    }

    public void setContext(AccContext<K, V> context) {
        this.context = context;
        this.currentState.setContext(context);
    }

    protected boolean processPendingInput() throws IOException {
        boolean completedAnObject = false;
        if (this.hasPendingInput && (completedAnObject = this.processInput(this.pendingInputStateId, this.pendingInput, this.pendingEnv, false))) {
            return completedAnObject;
        }
        return completedAnObject;
    }

    public boolean accumulate(I input, E env) throws IOException {
        String source = "foo";
        Object inputStateId = this.inputToStateId.apply(input, env);
        if (this.processPendingInput()) {
            return true;
        }
        if (this.currentSource != null && !Objects.equals(source, this.currentSource)) {
            this.endCurrentItem();
            this.currentSource = null;
        }
        boolean isNewSource = false;
        if (this.currentSource == null) {
            isNewSource = true;
            ++this.sourcesSeen;
            if (this.isSingle && this.sourcesSeen > 1L) {
                throw new RuntimeException("Too many results. Maybe use @one(self: false)?");
            }
            this.currentSource = source;
            this.currentState.begin(this.currentSource, input, env, false);
            isNewSource = true;
        }
        this.hasPendingInput = false;
        boolean completedAnObject = this.processInput(inputStateId, input, env, isNewSource);
        return completedAnObject;
    }

    public boolean processInput(Object inputStateId, I input, E env, boolean isNewSource) throws IOException {
        boolean completedAnItem;
        block2: {
            AccState nextState;
            completedAnItem = false;
            while ((nextState = this.currentState.transition(inputStateId, (Object)input, (Object)env)) == null) {
                this.currentState.end();
                AccState parentAcc = this.currentState.getParent();
                if (parentAcc == null) {
                    throw new RuntimeException("No acceptable transition for " + String.valueOf(input));
                }
                this.currentState = parentAcc;
                if (this.currentState.getParent() != null) continue;
                completedAnItem = true;
                this.hasPendingInput = true;
                this.pendingInput = input;
                this.pendingEnv = env;
                this.pendingInputStateId = inputStateId;
                break block2;
            }
            this.currentState = nextState;
        }
        return completedAnItem;
    }

    public boolean end() throws IOException {
        boolean result = this.hasPendingInput ? this.processInput(this.pendingInputStateId, this.pendingInput, this.pendingEnv, false) : this.currentState.getParent() != null;
        this.endCurrentItem();
        this.currentSource = null;
        return result;
    }

    protected void endCurrentItem() throws IOException {
        while (true) {
            AccState parent;
            if (this.currentState.hasBegun()) {
                this.currentState.end();
            }
            if ((parent = this.currentState.getParent()) == null) break;
            this.currentState = parent;
        }
    }
}

