/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.acc.state.api;

import graphql.com.google.common.base.Preconditions;
import java.io.IOException;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccContext;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateGon;

public abstract class AccStateBase<I, E, K, V>
implements AccStateGon<I, E, K, V> {
    protected AccStateGon<I, E, K, V> parent;
    protected Object oldSourceNode;
    protected boolean hasBegun = false;
    protected Object currentSourceNode;
    protected I parentInput;
    protected I currentInput;
    protected boolean skipOutput = false;
    protected AccContext<K, V> context;
    protected Object stateId;

    @Override
    public Object getStateId() {
        return this.stateId;
    }

    @Override
    public void setParent(AccStateGon<I, E, K, V> parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Parent already set");
        }
        this.parent = parent;
    }

    @Override
    public void setContext(AccContext<K, V> context) {
        this.context = context;
        this.setContextOnChildren(context);
    }

    protected void setContextOnChildren(AccContext<K, V> context) {
        this.children().forEachRemaining(child -> child.setContext(context));
    }

    @Override
    public AccStateGon<I, E, K, V> getParent() {
        return this.parent;
    }

    @Override
    public boolean hasBegun() {
        return this.hasBegun;
    }

    public void ensureBegun() {
        Preconditions.checkState((this.hasBegun ? 1 : 0) != 0);
    }

    @Override
    public final AccStateGon<I, E, K, V> transition(Object inputStateId, I input, E env) throws IOException {
        this.ensureBegun();
        this.currentInput = input;
        AccStateGon<I, E, K, V> result = this.transitionActual(inputStateId, input, env);
        return result;
    }

    @Override
    public final void begin(Object fromStateId, I parentInput, E env, boolean skipOutput) throws IOException {
        if (this.hasBegun) {
            throw new IllegalStateException("begin() has already been called() with " + String.valueOf(this.currentSourceNode));
        }
        this.hasBegun = true;
        this.currentSourceNode = null;
        this.currentInput = null;
        this.skipOutput = skipOutput;
        this.parentInput = parentInput;
        this.beginActual();
    }

    @Override
    public final void end() throws IOException {
        if (!this.hasBegun) {
            throw new IllegalStateException("end() was called without matching begin() at " + String.valueOf(this.currentSourceNode));
        }
        this.endActual();
        this.oldSourceNode = this.currentSourceNode;
        this.currentSourceNode = null;
        this.hasBegun = false;
    }

    public abstract AccStateGon<I, E, K, V> transitionActual(Object var1, I var2, E var3) throws IOException;

    protected void beginActual() throws IOException {
    }

    protected void endActual() throws IOException {
    }
}

