/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.schema;

import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;

public class GraphQlSchemaUtils {
    public static TypeInfo extractTypeInfo(Type<?> type) {
        boolean isList = false;
        boolean isNonNull = false;
        while (true) {
            if (type instanceof NonNullType) {
                NonNullType nonNullType = (NonNullType)type;
                isNonNull = true;
                type = nonNullType.getType();
                continue;
            }
            if (!(type instanceof ListType)) break;
            ListType listType = (ListType)type;
            isList = true;
            type = listType.getType();
        }
        if (type instanceof TypeName) {
            TypeName typeName = (TypeName)type;
            return new TypeInfo(typeName.getName(), isList, isNonNull);
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(type));
    }

    public static class TypeInfo {
        private final String typeName;
        private final boolean isList;
        private final boolean isNonNull;

        public TypeInfo(String typeName, boolean isList, boolean isNonNull) {
            this.typeName = typeName;
            this.isList = isList;
            this.isNonNull = isNonNull;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isList() {
            return this.isList;
        }

        public boolean isNonNull() {
            return this.isNonNull;
        }

        public String toString() {
            return (this.isNonNull ? "NonNull " : "") + (this.isList ? "List<" : "") + this.typeName + (this.isList ? ">" : "");
        }
    }
}

