/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.rewrite;

import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.OperationDefinition;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TransformAssignGlobalIds
extends NodeVisitorStub {
    protected Supplier<String> idGenerator;

    public TransformAssignGlobalIds(Supplier<String> idGenerator) {
        this.idGenerator = Objects.requireNonNull(idGenerator);
    }

    public static TransformAssignGlobalIds of(String baseName, int start) {
        int[] nextId = new int[]{start};
        return new TransformAssignGlobalIds(() -> {
            int n = nextId[0];
            nextId[0] = n + 1;
            return baseName + n;
        });
    }

    public TraversalControl visitOperationDefinition(OperationDefinition node, TraverserContext<Node> context) {
        return OperationDefinition.Operation.QUERY.equals((Object)node.getOperation()) ? this.transform(node, context, newDirectives -> {
            OperationDefinition newNode = node.transform(builder -> builder.directives(newDirectives));
            TreeTransformerUtil.changeNode((TraverserContext)context, (Object)newNode);
        }) : TraversalControl.CONTINUE;
    }

    public TraversalControl visitField(Field field, TraverserContext<Node> context) {
        return this.transform(field, context, newDirectives -> {
            Field newNode = field.transform(builder -> builder.directives(newDirectives));
            TreeTransformerUtil.changeNode((TraverserContext)context, (Object)newNode);
        });
    }

    public TraversalControl visitInlineFragment(InlineFragment field, TraverserContext<Node> context) {
        return this.transform(field, context, newDirectives -> {
            InlineFragment newNode = field.transform(builder -> builder.directives(newDirectives));
            TreeTransformerUtil.changeNode((TraverserContext)context, (Object)newNode);
        });
    }

    public <T extends DirectivesContainer<?>> TraversalControl transform(T node, TraverserContext<Node> context, Consumer<List<Directive>> action) {
        if (!context.isVisited()) {
            LinkedList remainingDirectives = node.getDirectives().stream().filter(directive -> !this.process((Directive)directive)).collect(Collectors.toCollection(LinkedList::new));
            String id = this.idGenerator.get();
            Directive d = Directive.newDirective().name("globalId").argument(Argument.newArgument((String)"id", (Value)StringValue.of((String)id)).build()).build();
            remainingDirectives.addFirst(d);
            action.accept(remainingDirectives);
        }
        return TraversalControl.CONTINUE;
    }

    protected boolean process(Directive node) {
        return "globalId".equals(node.getName());
    }
}

