/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.io;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.aksw.jenax.graphql.sparql.v2.io.GraphQlIoBridge;
import org.aksw.jenax.graphql.sparql.v2.io.RdfObjectNotationWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.path.P_Path0;

public class RdfObjectNotationWriterViaJson
implements RdfObjectNotationWriter {
    protected Gson gson;
    protected JsonWriter jsonWriter;

    public RdfObjectNotationWriterViaJson(Gson gson, JsonWriter jsonWriter) {
        this(gson, jsonWriter, false);
    }

    public RdfObjectNotationWriterViaJson(Gson gson, JsonWriter jsonWriter, boolean rdfTermMode) {
        this.gson = gson;
        this.jsonWriter = jsonWriter;
    }

    @Override
    public void flush() throws IOException {
        this.jsonWriter.flush();
    }

    @Override
    public RdfObjectNotationWriter beginArray() throws IOException {
        this.jsonWriter.beginArray();
        return this;
    }

    @Override
    public RdfObjectNotationWriter endArray() throws IOException {
        this.jsonWriter.endArray();
        return this;
    }

    @Override
    public RdfObjectNotationWriter beginObject() throws IOException {
        this.jsonWriter.beginObject();
        return this;
    }

    @Override
    public RdfObjectNotationWriter endObject() throws IOException {
        this.jsonWriter.endObject();
        return this;
    }

    @Override
    public RdfObjectNotationWriter name(P_Path0 name) throws IOException {
        String str = RdfObjectNotationWriterViaJson.nodeToJsonKey(name);
        this.jsonWriter.name(str);
        return this;
    }

    @Override
    public RdfObjectNotationWriter value(Node value) throws IOException {
        JsonElement elt = GraphQlIoBridge.nodeToJsonElement(value);
        this.gson.toJson(elt, this.jsonWriter);
        return this;
    }

    @Override
    public RdfObjectNotationWriter nullValue() throws IOException {
        this.jsonWriter.nullValue();
        return this;
    }

    public static String nodeToJsonKey(P_Path0 name) {
        return RdfObjectNotationWriterViaJson.nodeToJsonKey(name.getNode());
    }

    public static String nodeToJsonKey(Node name) {
        boolean strict = false;
        String result = strict ? name.getLiteralLexicalForm() : (name.isLiteral() ? name.getLiteralLexicalForm() : (name.isURI() ? name.getURI() : NodeFmtLib.strNT((Node)name)));
        return result;
    }
}

