/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.gon.model;

import org.aksw.jenax.graphql.sparql.v2.gon.model.GonArray;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonElementVisitor;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonLiteral;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonNull;
import org.aksw.jenax.graphql.sparql.v2.gon.model.GonObject;
import org.aksw.jenax.graphql.sparql.v2.gon.model.ParentLink;
import org.aksw.jenax.graphql.sparql.v2.gon.model.ParentLinkArray;
import org.aksw.jenax.graphql.sparql.v2.gon.model.ParentLinkObject;
import org.aksw.jenax.graphql.sparql.v2.ron.RdfObject;

public interface GonElement<K, V> {
    default public boolean isArray() {
        return this instanceof GonArray;
    }

    default public GonArray<K, V> getAsArray() {
        return (GonArray)this;
    }

    default public boolean isObject() {
        return this instanceof RdfObject;
    }

    default public GonObject<K, V> getAsObject() {
        return (GonObject)this;
    }

    default public boolean isLiteral() {
        return this instanceof GonLiteral;
    }

    default public GonLiteral<K, V> getAsLiteral() {
        return (GonLiteral)this;
    }

    default public boolean isNull() {
        return this instanceof GonNull;
    }

    default public GonNull<K, V> asNull() {
        return (GonNull)this;
    }

    public <T> T accept(GonElementVisitor<K, V, T> var1);

    public ParentLink<K, V> getParent();

    default public void unlinkFromParent() {
        ParentLink<K, V> link = this.getParent();
        if (link != null) {
            if (link.isObjectLink()) {
                ParentLinkObject<K, V> objLink = link.asObjectLink();
                K key = objLink.getKey();
                objLink.getParent().remove(key);
            } else if (link.isArrayLink()) {
                ParentLinkArray<K, V> arrLink = link.asArrayLink();
                int index = arrLink.getIndex();
                arrLink.getParent().set(index, new GonNull());
            } else {
                throw new RuntimeException("Unknown parent link type: " + String.valueOf(link.getClass()));
            }
        }
    }

    default public GonElement<K, V> getRoot() {
        ParentLink<K, V> link = this.getParent();
        GonElement<K, V> result = link == null ? this : link.getParent().getRoot();
        return result;
    }
}

